/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class ST
    extends SimpleTypeMetaData
{
    public static ST[] create(String value, String repeatDelimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData.splitData(value,
                repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            ST[] elements = new ST[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = ST.create(components[index]);
            }

            return elements;
        }
    }

    public static ST create(String value)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            return new ST(value);
        }
    }
    // Support CCR 10300 delete parent name
    public static ST createForParent(String value)
    {
        if((value == null) || "\"\"".equals(value)) {
            return null;
        }
        else
        {
            return new ST(value);
        }
    }   
    
    public static String getDataString(ST[] data, String repeatDelimiter)
    {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter,
            null, null);
    }

    ST(String value)
    {
        super(value);
    }
}