/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

//Java Classes

//Library Classes

//Framework Classes

//Common Classes

//Messaging Classes

/**
 * @author Martin Francisco
 */
public class PN
    extends ComplexTypeMetaData
{
    private static final int POSITION_FAMILY_NAME = 0;
    private static final int POSITION_GIVEN_NAME = 1;
    private static final int POSITION_MIDDLE_NAME = 2;
    private static final int POSITION_SUFFIX = 3;
    private static final int POSITION_PREFIX = 4;
    private static final int POSITION_DEGREE = 5;
    private static final int DATA_SIZE = 6;

    public static PN[] create(
        String value,
        String repeatDelimiter,
        String delimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData.splitData(value,
                repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            PN[] elements = new PN[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = PN.create(components[index], delimiter);
            }

            return elements;
        }
    }

    public static PN create()
    {
        return new PN(new AbstractDataTypeMetaData[PN.DATA_SIZE]);
    }

    public static PN create(String value, String delimiter)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[PN.DATA_SIZE];

            String[] components = AbstractDataTypeMetaData.splitData(value,
                delimiter);
            int size = (components == null) ? 0 : components.length;

            data[PN.POSITION_FAMILY_NAME] = (size > PN.POSITION_FAMILY_NAME) ? ST
                .create(components[PN.POSITION_FAMILY_NAME])
                : null;
            data[PN.POSITION_GIVEN_NAME] = (size > PN.POSITION_GIVEN_NAME) ? ST
                .create(components[PN.POSITION_GIVEN_NAME])
                : null;
            data[PN.POSITION_MIDDLE_NAME] = (size > PN.POSITION_MIDDLE_NAME) ? ST
                .create(components[PN.POSITION_MIDDLE_NAME])
                : null;
            data[PN.POSITION_SUFFIX] = (size > PN.POSITION_SUFFIX) ? ST
                .create(components[PN.POSITION_SUFFIX]) : null;
            data[PN.POSITION_PREFIX] = (size > PN.POSITION_PREFIX) ? ST
                .create(components[PN.POSITION_PREFIX]) : null;
            data[PN.POSITION_DEGREE] = (size > PN.POSITION_DEGREE) ? IS
                .create(components[PN.POSITION_DEGREE]) : null;

            return new PN(data);
        }
    }
    // CCR 10300 support parent name delete
    public static PN createForParent(String value, String delimiter)
    {
        if((value == null) || "\"\"".equals(value))
        {
            return null;
        }
        else
        {
            AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[PN.DATA_SIZE];

            String[] components = AbstractDataTypeMetaData.splitData(value,
                delimiter);
            int size = (components == null) ? 0 : components.length;

            data[PN.POSITION_FAMILY_NAME] = (size > PN.POSITION_FAMILY_NAME) ? ST
                .createForParent(components[PN.POSITION_FAMILY_NAME])
                : null;
            data[PN.POSITION_GIVEN_NAME] = (size > PN.POSITION_GIVEN_NAME) ? ST
                .createForParent(components[PN.POSITION_GIVEN_NAME])
                : null;
            data[PN.POSITION_MIDDLE_NAME] = (size > PN.POSITION_MIDDLE_NAME) ? ST
                .createForParent(components[PN.POSITION_MIDDLE_NAME])
                : null;
            data[PN.POSITION_SUFFIX] = (size > PN.POSITION_SUFFIX) ? ST
                .create(components[PN.POSITION_SUFFIX]) : null;
            data[PN.POSITION_PREFIX] = (size > PN.POSITION_PREFIX) ? ST
                .create(components[PN.POSITION_PREFIX]) : null;
            data[PN.POSITION_DEGREE] = (size > PN.POSITION_DEGREE) ? IS
                .create(components[PN.POSITION_DEGREE]) : null;

            return new PN(data);
        }
    }
    public static String getDataString(
        PN[] data,
        String repeatDelimiter,
        String delimiter)
    {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter,
            delimiter, null);
    }

    PN(AbstractDataTypeMetaData[] data)
    {
        super(data);
    }

    /**
     * Component 1
     */
    public ST getFamilyName()
    {
        return (ST)super.getData(PN.POSITION_FAMILY_NAME);
    }

    /**
     * Component 1
     */
    public void setFamilyName(ST familyName)
    {
        super.setData(PN.POSITION_FAMILY_NAME, familyName);
    }

    /**
     * Component 2
     */
    public ST getGivenName()
    {
        return (ST)super.getData(PN.POSITION_GIVEN_NAME);
    }

    /**
     * Component 2
     */
    public void setGivenName(ST givenName)
    {
        super.setData(PN.POSITION_GIVEN_NAME, givenName);
    }

    /**
     * Component 3
     */
    public ST getMiddleName()
    {
        return (ST)super.getData(PN.POSITION_MIDDLE_NAME);
    }

    /**
     * Component 3
     */
    public void setMiddleName(ST middleName)
    {
        super.setData(PN.POSITION_MIDDLE_NAME, middleName);
    }

    /**
     * Component 4
     */
    public ST getSuffix()
    {
        return (ST)super.getData(PN.POSITION_SUFFIX);
    }

    /**
     * Component 4
     */
    public void setSuffix(ST suffix)
    {
        super.setData(PN.POSITION_SUFFIX, suffix);
    }

    /**
     * Component 5
     */
    public ST getPrefix()
    {
        return (ST)super.getData(PN.POSITION_PREFIX);
    }

    /**
     * Component 5
     */
    public void setPrefix(ST prefix)
    {
        super.setData(PN.POSITION_PREFIX, prefix);
    }

    /**
     * Component 6
     */
    public IS getDegree()
    {
        return (IS)super.getData(PN.POSITION_DEGREE);
    }

    /**
     * Component 6
     */
    public void setDegree(IS degree)
    {
        super.setData(PN.POSITION_DEGREE, degree);
    }

    public final String getDataString(String delimiter)
    {
        return super.getDataString(delimiter, null);
    }
}