/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class NM
    extends SimpleTypeMetaData
{
    public static NM[] create(String value, String repeatDelimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData.splitData(value,
                repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            NM[] elements = new NM[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = NM.create(components[index]);
            }

            return elements;
        }
    }

    public static NM create(String value)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            return new NM(value);
        }
    }

    public static String getDataString(NM[] data, String repeatDelimiter)
    {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter,
            null, null);
    }

    NM(String value)
    {
        super(value);
    }
}