/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class IS
    extends SimpleTypeMetaData
{
    public static IS[] create(String value, String repeatDelimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData.splitData(value,
                repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            IS[] elements = new IS[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = IS.create(components[index]);
            }

            return elements;
        }
    }

    public static IS create(String value)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            return new IS(value);
        }
    }

    public static String getDataString(IS[] data, String repeatDelimiter)
    {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter,
            null, null);
    }

    IS(String value)
    {
        super(value);
    }
}