/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class ID
    extends SimpleTypeMetaData
{
    public static ID[] create(String value, String repeatDelimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData.splitData(value,
                repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            ID[] elements = new ID[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = ID.create(components[index]);
            }

            return elements;
        }
    }

    public static ID create(String value)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            return new ID(value);
        }
    }

    public static String getDataString(ID[] data, String repeatDelimiter)
    {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter,
            null, null);
    }

    ID(String value)
    {
        super(value);
    }
}