/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

//Java Classes

//Library Classes

//Framework Classes

//Common Classes

//Messaging Classes

/**
 * @author Martin Francisco
 */
public class HD
    extends ComplexTypeMetaData
{
    private static final int POSITION_NAMESPACE_ID = 0;
    private static final int POSITION_UNIVERSAL_ID = 1;
    private static final int POSITION_UNIVERSAL_ID_TYPE = 2;
    private static final int DATA_SIZE = 3;

    public static HD[] create(
        String value,
        String repeatDelimiter,
        String delimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData
                .splitData(value, repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            HD[] elements = new HD[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = HD.create(components[index], delimiter);
            }

            return elements;
        }
    }

    public static HD create()
    {
        return new HD(new AbstractDataTypeMetaData[HD.DATA_SIZE]);
    }

    public static HD create(String value, String delimiter)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[HD.DATA_SIZE];

            String[] components = AbstractDataTypeMetaData
                .splitData(value, delimiter);
            int size = (components == null) ? 0 : components.length;

            data[HD.POSITION_NAMESPACE_ID] = (size > HD.POSITION_NAMESPACE_ID) ? IS
                .create(components[HD.POSITION_NAMESPACE_ID])
                : null;
            data[HD.POSITION_UNIVERSAL_ID] = (size > HD.POSITION_UNIVERSAL_ID) ? ST
                .create(components[HD.POSITION_UNIVERSAL_ID])
                : null;
            data[HD.POSITION_UNIVERSAL_ID_TYPE] = (size > HD.POSITION_UNIVERSAL_ID_TYPE) ? ID
                .create(components[HD.POSITION_UNIVERSAL_ID_TYPE])
                : null;

            return new HD(data);
        }
    }

    public static String getDataString(
        HD[] data,
        String repeatDelimiter,
        String delimiter)
    {
        return AbstractDataTypeMetaData
            .formatDataString(data, repeatDelimiter, delimiter, null);
    }

    HD(AbstractDataTypeMetaData[] data)
    {
        super(data);
    }

    /**
     * Component 1
     */
    public IS getNamespaceID()
    {
        return (IS)super.getData(HD.POSITION_NAMESPACE_ID);
    }

    /**
     * Component 1
     */
    public void setNamespaceID(IS namespaceID)
    {
        super.setData(HD.POSITION_NAMESPACE_ID, namespaceID);
    }

    /**
     * Component 2
     */
    public ST getUniversalID()
    {
        return (ST)super.getData(HD.POSITION_UNIVERSAL_ID);
    }

    /**
     * Component 2
     */
    public void setUniversalID(ST universalID)
    {
        super.setData(HD.POSITION_UNIVERSAL_ID, universalID);
    }

    /**
     * Component 3
     */
    public ID getUniversalIDType()
    {
        return (ID)super.getData(HD.POSITION_UNIVERSAL_ID_TYPE);
    }

    /**
     * Component 3
     */
    public void setUniversalIDType(ID universalIDType)
    {
        super.setData(HD.POSITION_UNIVERSAL_ID_TYPE, universalIDType);
    }

    public final String getDataString(String delimiter)
    {
        return super.getDataString(delimiter, null);
    }
}