/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class FT
    extends SimpleTypeMetaData
{
    public static FT[] create(String value, String repeatDelimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData.splitData(value,
                repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            FT[] elements = new FT[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = FT.create(components[index]);
            }

            return elements;
        }
    }

    public static FT create(String value)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            return new FT(value);
        }
    }

    public static String getDataString(FT[] data, String repeatDelimiter)
    {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter,
            null, null);
    }

    FT(String value)
    {
        super(value);
    }
}