/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

//Java Classes

//Library Classes

//Framework Classes

//Common Classes

//Messaging Classes

/**
 * @author Martin Francisco
 */
public class EI
    extends ComplexTypeMetaData
{
    private static final int POSITION_ENTITY_ID = 0;
    private static final int POSITION_NAMESPACE_ID = 1;
    private static final int POSITION_UNIVERSAL_ID = 2;
    private static final int POSITION_UNIVERSAL_ID_TYPE = 3;
    private static final int DATA_SIZE = 4;

    public static EI[] create(
        String value,
        String repeatDelimiter,
        String delimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData
                .splitData(value, repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            EI[] elements = new EI[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = EI.create(components[index], delimiter);
            }

            return elements;
        }
    }

    public static EI create()
    {
        return new EI(new AbstractDataTypeMetaData[EI.DATA_SIZE]);
    }

    public static EI create(String value, String delimiter)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[EI.DATA_SIZE];

            String[] components = AbstractDataTypeMetaData
                .splitData(value, delimiter);
            int size = (components == null) ? 0 : components.length;

            data[EI.POSITION_ENTITY_ID] = (size > EI.POSITION_ENTITY_ID) ? ST
                .create(components[EI.POSITION_ENTITY_ID]) : null;
            data[EI.POSITION_NAMESPACE_ID] = (size > EI.POSITION_NAMESPACE_ID) ? IS
                .create(components[EI.POSITION_NAMESPACE_ID])
                : null;
            data[EI.POSITION_UNIVERSAL_ID] = (size > EI.POSITION_UNIVERSAL_ID) ? ST
                .create(components[EI.POSITION_UNIVERSAL_ID])
                : null;
            data[EI.POSITION_UNIVERSAL_ID_TYPE] = (size > EI.POSITION_UNIVERSAL_ID_TYPE) ? ID
                .create(components[EI.POSITION_UNIVERSAL_ID_TYPE])
                : null;

            return new EI(data);
        }
    }

    public static String getDataString(
        EI[] data,
        String repeatDelimiter,
        String delimiter)
    {
        return AbstractDataTypeMetaData
            .formatDataString(data, repeatDelimiter, delimiter, null);
    }

    EI(AbstractDataTypeMetaData[] data)
    {
        super(data);
    }

    /**
     * Component 1
     */
    public ST getEntityID()
    {
        return (ST)super.getData(EI.POSITION_ENTITY_ID);
    }

    /**
     * Component 1
     */
    public void setEntityID(ST entityID)
    {
        super.setData(EI.POSITION_ENTITY_ID, entityID);
    }

    /**
     * Component 2
     */
    public IS getNamespaceID()
    {
        return (IS)super.getData(EI.POSITION_NAMESPACE_ID);
    }

    /**
     * Component 2
     */
    public void setNamespaceID(IS namespaceID)
    {
        super.setData(EI.POSITION_NAMESPACE_ID, namespaceID);
    }

    /**
     * Component 3
     */
    public ST getUniversalID()
    {
        return (ST)super.getData(EI.POSITION_UNIVERSAL_ID);
    }

    /**
     * Component 3
     */
    public void setUniversalID(ST universalID)
    {
        super.setData(EI.POSITION_UNIVERSAL_ID, universalID);
    }

    /**
     * Component 4
     */
    public ID getUniversalIDType()
    {
        return (ID)super.getData(EI.POSITION_UNIVERSAL_ID_TYPE);
    }

    /**
     * Component 4
     */
    public void setUniversalIDType(ID universalIDType)
    {
        super.setData(EI.POSITION_UNIVERSAL_ID_TYPE, universalIDType);
    }

    public final String getDataString(String delimiter)
    {
        return super.getDataString(delimiter, null);
    }
}