/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

//Java Classes

//Library Classes

//Framework Classes

//Common Classes

//Messaging Classes

/**
 * @author Martin Francisco
 */
public class DR
    extends ComplexTypeMetaData
{
    private static final int POSITION_START_DATETIME = 0;
    private static final int POSITION_END_DATETIME = 1;
    private static final int DATA_SIZE = 2;

    public static DR[] create(
        String value,
        String repeatDelimiter,
        String delimiter,
        String subDelimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData
                .splitData(value, repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            DR[] elements = new DR[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = DR
                    .create(components[index], delimiter, subDelimiter);
            }

            return elements;
        }
    }

    public static DR create()
    {
        return new DR(new AbstractDataTypeMetaData[DR.DATA_SIZE]);
    }

    public static DR create(String value, String delimiter, String subDelimiter)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[DR.DATA_SIZE];

            String[] components = AbstractDataTypeMetaData
                .splitData(value, delimiter);
            int size = (components == null) ? 0 : components.length;

            data[DR.POSITION_START_DATETIME] = (size > DR.POSITION_START_DATETIME) ? TS
                .create(components[DR.POSITION_START_DATETIME], subDelimiter)
                : null;
            data[DR.POSITION_END_DATETIME] = (size > DR.POSITION_END_DATETIME) ? TS
                .create(components[DR.POSITION_END_DATETIME], subDelimiter)
                : null;

            return new DR(data);
        }
    }

    public static String getDataString(
        DR[] data,
        String repeatDelimiter,
        String delimiter)
    {
        return AbstractDataTypeMetaData
            .formatDataString(data, repeatDelimiter, delimiter, null);
    }

    DR(AbstractDataTypeMetaData[] data)
    {
        super(data);
    }

    /**
     * Component 1
     */
    public TS getStartDateTime()
    {
        return (TS)super.getData(DR.POSITION_START_DATETIME);
    }

    /**
     * Component 1
     */
    public void setStartDateTime(TS startDateTime)
    {
        super.setData(DR.POSITION_START_DATETIME, startDateTime);
    }

    /**
     * Component 2
     */
    public TS getEndDateTime()
    {
        return (TS)super.getData(DR.POSITION_END_DATETIME);
    }

    /**
     * Component 2
     */
    public void setEndDateTime(TS endDateTime)
    {
        super.setData(DR.POSITION_END_DATETIME, endDateTime);
    }
}