/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

// Java Classes

// Library Classes
import org.apache.commons.lang.Validate;

// Framework Classes

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public abstract class ComplexTypeMetaData
    extends AbstractDataTypeMetaData
{
    private AbstractDataTypeMetaData[] data = null;

    protected ComplexTypeMetaData(AbstractDataTypeMetaData[] data)
    {
        super();
        Validate.notNull(data, "data cannot be null");
        this.data = data;
    }

    public final String getDataString(String delimiter, String subDelimiter)
    {
        StringBuffer buffer = new StringBuffer();

        int lastDataIndex = this.data.length - 1;
        while((lastDataIndex >= 0) && (this.data[lastDataIndex] == null))
        {
            lastDataIndex--;
        }

        if(lastDataIndex >= 0)
        {
            for(int index = 0; index < lastDataIndex; index++)
            {
                buffer.append(
                    this.data[index].getDataString(subDelimiter, null)).append(
                    delimiter);
            }

            buffer.append(this.data[lastDataIndex].getDataString(subDelimiter,
                null));
        }

        return buffer.toString();
    }

    /**
     * @return Returns the data.
     */
    protected final AbstractDataTypeMetaData getData(int position)
    {
        return this.data[position];
    }

    protected final void setData(int position, AbstractDataTypeMetaData data)
    {
        this.data[position] = data;
    }
}