package gov.va.med.esr.common.builder.datatype.metadata;

/**
 * 
 * @author Rajiv Patnaik Created on Jan 31, 2006
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class CX extends ComplexTypeMetaData
{
    
    private static final int POSITION_IDENTIFIER = 0;

    private static final int POSITION_ID_CHECK_DIGIT = 1;

    private static final int POSITION_ID_CHECK_DIGIT_SCHEME_CODE = 2;

    private static final int POSITION_ASSIGNING_AUTHORITY = 3;

    private static final int POSITION_IDENTFIER_TYPE_CODE = 4;

    private static final int POSITION_ASSIGNING_FACILITY = 5;

    private static final int POSITION_EFFECTIVE_DATE = 6;

    private static final int POSITION_EXPIRATION_DATE = 7;

    private static final int DATA_SIZE = 8;

    /**
     * @param data
     */
    protected CX(AbstractDataTypeMetaData[] data)
    {
        super(data);
    }

    public static CX[] create(String value, String repeatDelimiter,
            String delimiter, String subDelimiter)
    {
        if (value == null)
        {
            return null;
        }

        String[] components = AbstractDataTypeMetaData.splitData(value,
                repeatDelimiter);
        int size = (components == null) ? 0 : components.length;

        CX[] elements = new CX[size];

        for (int index = 0; index < size; index++)
        {
            elements[index] = CX.create(components[index], delimiter,
                    subDelimiter);
        }

        return elements;

    }

    public static CX create()
    {
        return new CX(new AbstractDataTypeMetaData[CX.DATA_SIZE]);
    }

    public static CX create(String value, String delimiter, String subDelimiter)
    {
        if (AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[CX.DATA_SIZE];

        String[] components = AbstractDataTypeMetaData.splitData(value,
                delimiter);
        int size = (components == null) ? 0 : components.length;

        data[CX.POSITION_IDENTIFIER] = (size > CX.POSITION_IDENTIFIER) ? ST
                .create(components[CX.POSITION_IDENTIFIER]) : null;

        data[CX.POSITION_ID_CHECK_DIGIT] = (size > CX.POSITION_ID_CHECK_DIGIT) ? ST
                .create(components[CX.POSITION_ID_CHECK_DIGIT]) : null;

        data[CX.POSITION_ID_CHECK_DIGIT_SCHEME_CODE] = (size > CX.POSITION_ID_CHECK_DIGIT_SCHEME_CODE) ? ID
                .create(components[CX.POSITION_ID_CHECK_DIGIT_SCHEME_CODE])
                : null;

        data[CX.POSITION_ASSIGNING_AUTHORITY] = (size > CX.POSITION_ASSIGNING_AUTHORITY) ? HD
                .create(components[CX.POSITION_ASSIGNING_AUTHORITY],
                        subDelimiter)
                : null;

        data[CX.POSITION_IDENTFIER_TYPE_CODE] = (size > CX.POSITION_IDENTFIER_TYPE_CODE) ? ID
                .create(components[CX.POSITION_IDENTFIER_TYPE_CODE])
                : null;

        data[CX.POSITION_ASSIGNING_FACILITY] = (size > CX.POSITION_ASSIGNING_FACILITY) ? HD
                .create(components[CX.POSITION_ASSIGNING_FACILITY],
                        subDelimiter)
                : null;

        data[CX.POSITION_EFFECTIVE_DATE] = (size > CX.POSITION_EFFECTIVE_DATE) ? ST
                .create(components[CX.POSITION_EFFECTIVE_DATE])
                : null;

        data[CX.POSITION_EXPIRATION_DATE] = (size > CX.POSITION_EXPIRATION_DATE) ? ST
                .create(components[CX.POSITION_EXPIRATION_DATE])
                : null;

        return new CX(data);

    }

    public static String getDataString(CX[] data, String repeatDelimiter,
            String delimiter)
    {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter,
                delimiter, null);
    }
    
    /**
     * Component 1
     */
    public ST getIdentifier()
    {
        return (ST)super.getData(POSITION_IDENTIFIER);
    }

    /**
     * Component 1
     */
    public void setIdentifier(ST identifier)
    {
        super.setData(POSITION_IDENTIFIER, identifier);
    }    
    
    /**
     * Component 2
     */
    public ST getIDCheckDigit()
    {
        return (ST)super.getData(POSITION_ID_CHECK_DIGIT);
    }

    /**
     * Component 2
     */
    public void setIDCheckDigit(ST idCheckDigit)
    {
        super.setData(POSITION_ID_CHECK_DIGIT, idCheckDigit);
    }    
    
    /**
     * Component 3
     */
    public ID getIDCheckDigitSchemeCode()
    {
        return (ID)super.getData(POSITION_ID_CHECK_DIGIT_SCHEME_CODE);
    }

    /**
     * Component 3
     */
    public void setIDCheckDigitSchemeCode(ID idCheckDigitSchemeCode)
    {
        super
            .setData(POSITION_ID_CHECK_DIGIT_SCHEME_CODE, idCheckDigitSchemeCode);
    }
    
    /**
     * Component 4
     */
    public HD getAssigningAuthority()
    {
        return (HD)super.getData(POSITION_ASSIGNING_AUTHORITY);
    }

    /**
     * Component 4
     */
    public void setAssigningAuthority(HD assigningAuthority)
    {
        super.setData(POSITION_ASSIGNING_AUTHORITY, assigningAuthority);
    }    

    /**
     * Component 5
     */
    public ID getIdentifierTypeCode()
    {
        return (ID)super.getData(POSITION_IDENTFIER_TYPE_CODE);
    }

    /**
     * Component 5
     */
    public void setIDTypeCode(ID identifierTypeCode)
    {
        super.setData(POSITION_IDENTFIER_TYPE_CODE, identifierTypeCode);
    }    
    
    /**
     * Component 6
     */
    public HD getAssigningFacility()
    {
        return (HD)super.getData(POSITION_ASSIGNING_FACILITY);
    }

    /**
     * Component 6
     */
    public void setAssigningFacility(HD assigningFacility)
    {
        super.setData(POSITION_ASSIGNING_FACILITY, assigningFacility);
    }
    
    
    /**
     * Component 7
     */
    public ST getEffectiveDate()
    {
        return (ST)super.getData(POSITION_EFFECTIVE_DATE);
    }
    /**
     * Component 7
     */
    public void setEffectiveDate(ST effectiveDate)
    {
        super.setData(POSITION_EFFECTIVE_DATE, effectiveDate);
    }
    
    /**
     * Component 8
     */
    public ST getExpirationDate()
    {
        return (ST)super.getData(POSITION_EXPIRATION_DATE);
    }
    
    /**
     * Component 8
     */
    public void setExpirationDate(ST expirationDate)
    {
        super.setData(POSITION_EXPIRATION_DATE, expirationDate);
    }
    
    /**
     * Get a Identifier(e.f national ICN, SSN) based on the IdentifierType from a 
     * array of CX types. If there are same IdentiferTypes in different CX elements , 
     * the first match will be returned 
     *   
     * @param CX[]
     * @param identifierType exampel PI,NI,SS,PN
     * @return Identifier value as String
     */
    public static String getIdentifierByIdentifierType(CX[] cxs, String identifierType)
    {
        String identifier = null;

        if (cxs != null)
        {
            for (int i = 0; i < cxs.length; i++)
            {
                CX cx = cxs[i];
                String currentIdentifierType = cx.getIdentifierTypeCode() == null ? null
                        : cx.getIdentifierTypeCode().getValue();
                if (identifierType.equals(currentIdentifierType))
                {
                    identifier = cx.getIdentifier().getValue();
                }
            }
        }

        return identifier;
    }    
    
}