/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

//Java Classes

//Library Classes

//Framework Classes

//Common Classes

//Messaging Classes

/**
 * @author Martin Francisco
 */
public class CE
    extends ComplexTypeMetaData
{
    private static final int POSITION_ID = 0;
    private static final int POSITION_TEXT = 1;
    private static final int POSITION_CODING_SYSTEM = 2;
    private static final int POSITION_ALTERNATE_ID = 3;
    private static final int POSITION_ALTERNATE_TEXT = 4;
    private static final int POSITION_ALTERNATE_CODING_SYSTEM = 5;
    private static final int DATA_SIZE = 6;

    public static CE[] create(
        String value,
        String repeatDelimiter,
        String delimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData.splitData(value,
                repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            CE[] elements = new CE[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = CE.create(components[index], delimiter);
            }

            return elements;
        }
    }

    public static CE create()
    {
        return new CE(new AbstractDataTypeMetaData[CE.DATA_SIZE]);
    }

    public static CE create(String value, String delimiter)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[CE.DATA_SIZE];

            String[] components = AbstractDataTypeMetaData.splitData(value,
                delimiter);
            int size = (components == null) ? 0 : components.length;

            data[CE.POSITION_ID] = (size > CE.POSITION_ID) ? ST
                .create(components[CE.POSITION_ID]) : null;
            data[CE.POSITION_TEXT] = (size > CE.POSITION_TEXT) ? ST
                .create(components[CE.POSITION_TEXT]) : null;
            data[CE.POSITION_CODING_SYSTEM] = (size > CE.POSITION_CODING_SYSTEM) ? ST
                .create(components[CE.POSITION_CODING_SYSTEM])
                : null;
            data[CE.POSITION_ALTERNATE_ID] = (size > CE.POSITION_ALTERNATE_ID) ? ST
                .create(components[CE.POSITION_ALTERNATE_ID])
                : null;
            data[CE.POSITION_ALTERNATE_TEXT] = (size > CE.POSITION_ALTERNATE_TEXT) ? ST
                .create(components[CE.POSITION_ALTERNATE_TEXT])
                : null;
            data[CE.POSITION_ALTERNATE_CODING_SYSTEM] = (size > CE.POSITION_ALTERNATE_CODING_SYSTEM) ? ST
                .create(components[CE.POSITION_ALTERNATE_CODING_SYSTEM])
                : null;

            return new CE(data);
        }
    }

    public static String getDataString(
        CE[] data,
        String repeatDelimiter,
        String delimiter)
    {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter,
            delimiter, null);
    }

    CE(AbstractDataTypeMetaData[] data)
    {
        super(data);
    }

    /**
     * Component 1
     */
    public ST getID()
    {
        return (ST)super.getData(CE.POSITION_ID);
    }

    /**
     * Component 1
     */
    public void setID(ST id)
    {
        super.setData(CE.POSITION_ID, id);
    }

    /**
     * Component 2
     */
    public ST getText()
    {
        return (ST)super.getData(CE.POSITION_TEXT);
    }

    /**
     * Component 2
     */
    public void setText(ST text)
    {
        super.setData(CE.POSITION_TEXT, text);
    }

    /**
     * Component 3
     */
    public ST getCodingSystem()
    {
        return (ST)super.getData(CE.POSITION_CODING_SYSTEM);
    }

    /**
     * Component 3
     */
    public void setCodingSystem(ST codingSystem)
    {
        super.setData(CE.POSITION_CODING_SYSTEM, codingSystem);
    }

    /**
     * Component 4
     */
    public ST getAlternateID()
    {
        return (ST)super.getData(CE.POSITION_ALTERNATE_ID);
    }

    /**
     * Component 4
     */
    public void setAlternateID(ST alternateID)
    {
        super.setData(CE.POSITION_ALTERNATE_ID, alternateID);
    }

    /**
     * Component 5
     */
    public ST getAlternateText()
    {
        return (ST)super.getData(CE.POSITION_ALTERNATE_TEXT);
    }

    /**
     * Component 5
     */
    public void setAlternateText(ST alternateText)
    {
        super.setData(CE.POSITION_ALTERNATE_TEXT, alternateText);
    }

    /**
     * Component 6
     */
    public ST getAlternateCodingSystem()
    {
        return (ST)super.getData(CE.POSITION_ALTERNATE_CODING_SYSTEM);
    }

    /**
     * Component 6
     */
    public void setAlternateCodingSystem(ST alternateCodingSystem)
    {
        super.setData(CE.POSITION_ALTERNATE_CODING_SYSTEM,
            alternateCodingSystem);
    }

    public final String getDataString(String delimiter)
    {
        return super.getDataString(delimiter, null);
    }
}