/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public abstract class AbstractDataTypeMetaData
{
    protected static String formatDataString(
        AbstractDataTypeMetaData[] data,
        String repeatDelimiter,
        String delimiter,
        String subDelimiter)
    {
        StringBuffer buffer = new StringBuffer();

        int lastDataIndex = data.length - 1;
        while((lastDataIndex >= 0) && (data[lastDataIndex] == null))
        {
            lastDataIndex--;
        }

        if(lastDataIndex >= 0)
        {
            for(int index = 0; index < lastDataIndex; index++)
            {
                buffer.append(
                    data[index].getDataString(delimiter, subDelimiter)).append(
                    repeatDelimiter);
            }

            buffer.append(data[lastDataIndex].getDataString(delimiter,
                subDelimiter));
        }

        return buffer.toString();
    }

    protected static boolean shouldDelete(String data)
    {
        return ((data == null) || "".equals(data) || "\"\"".equals(data));
    }

    protected static String[] splitData(String data, String delimiter)
    {
        String formattedDelimiter = ("|".equals(delimiter)
            || "[".equals(delimiter) || "]".equals(delimiter)
            || "\\".equals(delimiter) || "(".equals(delimiter)
            || ")".equals(delimiter) || "{".equals(delimiter)
            || "}".equals(delimiter) || "^".equals(delimiter)
            || "-".equals(delimiter) || "&".equals(delimiter)
            || ".".equals(delimiter) || "$".equals(delimiter)
            || "?".equals(delimiter) || "+".equals(delimiter)
            || "*".equals(delimiter) ? ("\\" + delimiter) : delimiter);
        return data.split(formattedDelimiter);
    }

    protected AbstractDataTypeMetaData()
    {
        super();
    }

    public abstract String getDataString(String delimiter, String subDelimiter);
}