/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

//Java Classes

//Library Classes

//Framework Classes

//Common Classes

//Messaging Classes

/**
 * @author Martin Francisco
 */
public class AD
    extends ComplexTypeMetaData
{
    private static final int POSITION_STREET_ADDRESS = 0;
    private static final int POSITION_OTHER_DESIGNATION = 1;
    private static final int POSITION_CITY = 2;
    private static final int POSITION_STATE = 3;
    private static final int POSITION_ZIP_CODE = 4;
    private static final int POSITION_COUNTRY_CODE = 5;
    private static final int POSITION_TYPE_CODE = 6;
    private static final int POSITION_OTHER_GEOGRAPHIC_DESIGNATION = 7;
    private static final int DATA_SIZE = 8;

    public static AD[] create(
        String value,
        String repeatDelimiter,
        String delimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData.splitData(value,
                repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            AD[] elements = new AD[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = AD.create(components[index], delimiter);
            }

            return elements;
        }
    }

    public static AD create()
    {
        return new AD(new AbstractDataTypeMetaData[AD.DATA_SIZE]);
    }

    public static AD create(String value, String delimiter)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[AD.DATA_SIZE];

            String[] components = AbstractDataTypeMetaData.splitData(value,
                delimiter);
            int size = (components == null) ? 0 : components.length;

            data[AD.POSITION_STREET_ADDRESS] = (size > AD.POSITION_STREET_ADDRESS) ? ST
                .create(components[AD.POSITION_STREET_ADDRESS])
                : null;
            data[AD.POSITION_OTHER_DESIGNATION] = (size > AD.POSITION_OTHER_DESIGNATION) ? ST
                .create(components[AD.POSITION_OTHER_DESIGNATION])
                : null;
            data[AD.POSITION_CITY] = (size > AD.POSITION_CITY) ? ST
                .create(components[AD.POSITION_CITY]) : null;
            data[AD.POSITION_STATE] = (size > AD.POSITION_STATE) ? ST
                .create(components[AD.POSITION_STATE]) : null;
            data[AD.POSITION_ZIP_CODE] = (size > AD.POSITION_ZIP_CODE) ? ST
                .create(components[AD.POSITION_ZIP_CODE]) : null;
            data[AD.POSITION_COUNTRY_CODE] = (size > AD.POSITION_COUNTRY_CODE) ? ID
                .create(components[AD.POSITION_COUNTRY_CODE])
                : null;
            data[AD.POSITION_TYPE_CODE] = (size > AD.POSITION_TYPE_CODE) ? ID
                .create(components[AD.POSITION_TYPE_CODE]) : null;
            data[AD.POSITION_OTHER_GEOGRAPHIC_DESIGNATION] = (size > AD.POSITION_OTHER_GEOGRAPHIC_DESIGNATION) ? ST
                .create(components[AD.POSITION_OTHER_GEOGRAPHIC_DESIGNATION])
                : null;

            return new AD(data);
        }
    }

    public static String getDataString(
        AD[] data,
        String repeatDelimiter,
        String delimiter)
    {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter,
            delimiter, null);
    }

    AD(AbstractDataTypeMetaData[] data)
    {
        super(data);
    }

    /**
     * Component 1
     */
    public ST getStreetAddress()
    {
        return (ST)super.getData(AD.POSITION_STREET_ADDRESS);
    }

    /**
     * Component 1
     */
    public void setStreetAddress(ST streetAddress)
    {
        super.setData(AD.POSITION_STREET_ADDRESS, streetAddress);
    }

    /**
     * Component 2
     */
    public ST getOtherDesignation()
    {
        return (ST)super.getData(AD.POSITION_OTHER_DESIGNATION);
    }

    /**
     * Component 2
     */
    public void setOtherDesignation(ST otherDesignation)
    {
        super.setData(AD.POSITION_OTHER_DESIGNATION, otherDesignation);
    }

    /**
     * Component 3
     */
    public ST getCity()
    {
        return (ST)super.getData(AD.POSITION_CITY);
    }

    /**
     * Component 3
     */
    public void setCity(ST city)
    {
        super.setData(AD.POSITION_CITY, city);
    }

    /**
     * Component 4
     */
    public ST getState()
    {
        return (ST)super.getData(AD.POSITION_STATE);
    }

    /**
     * Component 4
     */
    public void setState(ST state)
    {
        super.setData(AD.POSITION_STATE, state);
    }

    /**
     * Component 5
     */
    public ST getZipCode()
    {
        return (ST)super.getData(AD.POSITION_ZIP_CODE);
    }

    /**
     * Component 5
     */
    public void setZipCode(ST zipCode)
    {
        super.setData(AD.POSITION_ZIP_CODE, zipCode);
    }

    /**
     * Component 6
     */
    public ID getCountryCode()
    {
        return (ID)super.getData(AD.POSITION_COUNTRY_CODE);
    }

    /**
     * Component 6
     */
    public void setCountryCode(ID countryCode)
    {
        super.setData(AD.POSITION_COUNTRY_CODE, countryCode);
    }

    /**
     * Component 7
     */
    public ID getTypeCode()
    {
        return (ID)super.getData(AD.POSITION_TYPE_CODE);
    }

    /**
     * Component 7
     */
    public void setTypeCode(ID typeCode)
    {
        super.setData(AD.POSITION_TYPE_CODE, typeCode);
    }

    /**
     * Component 8
     */
    public ST getOtherGeographicDesignation()
    {
        return (ST)super.getData(AD.POSITION_OTHER_GEOGRAPHIC_DESIGNATION);
    }

    /**
     * Component 8
     */
    public void setOtherGeographicDesignation(ST otherGeographicDesignation)
    {
        super.setData(AD.POSITION_OTHER_GEOGRAPHIC_DESIGNATION,
            otherGeographicDesignation);
    }

    public final String getDataString(String delimiter)
    {
        return super.getDataString(delimiter, null);
    }
}