/*
 * Created on Feb 16, 2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.common.builder.comms;

import gov.va.med.esr.common.model.comms.AacLetterRequest;
import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.person.Person;
/**
 * @author DNS   TSAIG
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class SsnRemoteFormatter extends AbstractLetterFormatter {
	private static final String H16_VALUE_1 = "Vet SSN Invalid";

	private static final String H16_VALUE_2 = "Vet Pseudo";

	private static final String H17_VALUE_1 = "Spouse SSN Invalid";

	private static final String H17_VALUE_2 = "Spouse Pseudo";

	private static final String H18_VALUE_1 = "Depen SSN Invalid";

	private static final String H18_VALUE_2 = "Depen Pseudo";

	// TODO: change this Singleton approach to be the Spring way
	private static IFormatter instance = new SsnRemoteFormatter();

	public static IFormatter getInstance() {
		return instance;
	}

	private SsnRemoteFormatter() {
	}

	
	protected void buildDataElementsH(StringBuffer dataElements,
			GeneralTransmission transmission, GenerateValues inputValues) {
		CommsTemplate template = inputValues.getOrigTemplate();
		SsnTransmission ssnTransmission = (SsnTransmission) transmission;

		AddressType addressType = transmission.getVeteranAddressType();
		String H16val = EMPTY_STRING;
		String H17val = EMPTY_STRING;
		String H18val = EMPTY_STRING;

		if (ComLetterTemplateType.FORM_NUMBER_290.getCode().equals(
				template.getCommsTemplateFormNumber())
				|| ComLetterTemplateType.FORM_NUMBER_291.getCode().equals(
						template.getCommsTemplateFormNumber())) {
			if(AacLetterRequest.VETERAN_LETTER.equals(inputValues.getCategoryType()))
				H16val = H16_VALUE_1;
			else if(AacLetterRequest.SPOUSE_LETTER.equals(inputValues.getCategoryType()))
				H17val = H17_VALUE_1;
			else if(AacLetterRequest.DEPENDENT_LETTER.equals(inputValues.getCategoryType()))
				H18val = H18_VALUE_1;
		} else if (ComLetterTemplateType.FORM_NUMBER_292.getCode().equals(
				template.getCommsTemplateFormNumber())
				|| ComLetterTemplateType.FORM_NUMBER_293.getCode().equals(
						template.getCommsTemplateFormNumber())) {
			if(AacLetterRequest.VETERAN_LETTER.equals(inputValues.getCategoryType()))
				H16val = H16_VALUE_2;
			else if(AacLetterRequest.SPOUSE_LETTER.equals(inputValues.getCategoryType()))
				H17val = H17_VALUE_2;
			else if(AacLetterRequest.DEPENDENT_LETTER.equals(inputValues.getCategoryType()))
				H18val = H18_VALUE_2;
		}

		dataElements.append("* H01=").append(
				ssnTransmission.getSsnErrorMessage()).append(FIELD_DELIMITER). // SSA
																				// Message,
																				// for
																				// ssn
																				// letters
																				// only
				append("* H02=").append(EMPTY_STRING).append(FIELD_DELIMITER)
				.append("* H03=").append(EMPTY_STRING).append(FIELD_DELIMITER)
				.append("* H04=").append(EMPTY_STRING).append(FIELD_DELIMITER)
				.append("* H05=").append(EMPTY_STRING).append(FIELD_DELIMITER). // Income
				// Threshold
				// Outpatient
				// Copay
				append("* H06=").append(EMPTY_STRING).append(FIELD_DELIMITER). // means
				// test
				// data
				// year
				append("* H07=").append(EMPTY_STRING).append(FIELD_DELIMITER)
				.append("* H08=").append(EMPTY_STRING).append(FIELD_DELIMITER). // Income
				// Threshold
				// additional
				// 90
				// ay
				// hospital
				// deductible
				append("* H09=").append(EMPTY_STRING).append(FIELD_DELIMITER). // Incomd
				// Threshold
				// additional
				// 90
				// day
				// hospital
				// per
				// diem
				append("* H10=").append(EMPTY_STRING).append(FIELD_DELIMITER). // outpatient
				// co-pay
				// threshold
				// for
				// specialty
				append("* H11=").append(EMPTY_STRING).append(FIELD_DELIMITER). // outpatient
				// co-pay
				// threshold
				// for
				// primary
				// care
				append("* H12=").append(EMPTY_STRING).append(FIELD_DELIMITER). // 20%
				// H07
				// med
				// deduct
				append("* H13=").append(EMPTY_STRING).append(FIELD_DELIMITER). // 20%
				// H08
				// hosp
				// deduct
				append("* H14=").append(EMPTY_STRING).append(FIELD_DELIMITER). // 20%
				// H09
				// hosp
				// diem
				append("* H15=").append(EMPTY_STRING).append(FIELD_DELIMITER). // 20%
				// H09
				// hosp
				// diem

				append("* H16=").append(H16val).append(FIELD_DELIMITER).append(
						"* H17=").append(H17val).append(FIELD_DELIMITER)
				.append("* H18=").append(H18val).append(FIELD_DELIMITER)
				.append("* H19=").append(
						addressType != null ? addressType.getCode()
								: EMPTY_STRING).append(FIELD_DELIMITER);
	}
    protected void buildDataElementsH20(StringBuffer dataElements,
            GeneralTransmission transmission, GenerateValues inputValues, Person person) {
      //H20 field is used only in welcome letter.
    }
    
}
