/*
 * Created on Dec 8, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.common.builder.comms;


import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Hashtable;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
//-----------------------------------------------------------------------
//
/// <summary>Summary Description for EnrollGenerateValues</summary>
/// This is a value-holder object used to pass a large number of arguments 
/// between the GUI and the application tier
/// 
/// <owner>Bruce Adams</owner>
/// 
/// <remarks>
/// 
/// <history>
/// <u>version 1.0</u><br></br>module created<br></br>
/// </history>
/// 
/// </remarks>
//
//-----------------------------------------------------------------------


public class GenerateValues {

	//--------------------------------------------------------------------
	// Static variable(s)
	//--------------------------------------------------------------------


	//--------------------------------------------------------------------
	// Constructor(s)
	//--------------------------------------------------------------------

	/// <summary>
	/// Creates a new EnrollGenerateValues object.
	/// </summary>
	public GenerateValues(Person person, String formNum, String incomeYear, 
	        BigDecimal workloadId, ITransmission trans)
	{
	    this.person = person;
	    this.formNumber = formNum;
	    this.incomeYear = incomeYear;
	    this.workloadId = workloadId;
	    this.transmission = trans;
	}
	
	public GenerateValues(Person person, CommsTemplate templ, String incomeYear, String workloadId)
	{
	    this.person = person;
	    this.origTemplate = templ;
	    this.incomeYear = incomeYear;
	    this.workloadId = new BigDecimal(workloadId);
	}
	/**
	 * @return Returns the caseNumber.
	 */
	public String getCaseNumber() {
		return caseNumber;
	}
	/**
	 * @param caseNumber The caseNumber to set.
	 */
	public void setCaseNumber(String caseNumber) {
		this.caseNumber = caseNumber;
	}
	/**
	 * Key value for CommsEvent entries, used only
	 * by the automatic letter generation process
	 * @return Returns the commsEventId.
	 */
	public String getCommsEventId() {
		return commsEventId;
	}
	/**
	 * @param commsEventId The commsEventId to set.
	 */
	public void setCommsEventId(String commsEventId) {
		this.commsEventId = commsEventId;
	}
	/**
	 * @return Returns the commsLog.
	 */
	public CommsLogEntry getCommsLog() {
		return commsLog;
	}
		/**
	 * @param commsLogId The commsLog to set.
	 */
	public void setCommsLog(CommsLogEntry commsLog) {
		this.commsLog = commsLog;
	}
	/**
	 * @return Returns the commsTemplateId.
	 */
	public String getCommsTemplateId() {
		return commsTemplateId;
	}
	/**
	 * @param commsTemplateId The commsTemplateId to set.
	 */
	public void setCommsTemplateId(String commsTemplateId) {
		this.commsTemplateId = commsTemplateId;
	}
	/**
	 * @return Returns a hashtable with key=data element name, 
	 * value= replacement text for the data element.
	 * This table is used for tag replacement for a particular letter.
	 */
	public Hashtable getDataElementNameValueTable() {
		return dataElementNameValueTable;
	}
	/**
	 * @param dataElementNameValueLst a hashtable with key=data element name, 
	 * value= replacement text for the data element.
	 * This table is used for tag replacement for a particular letter.
	 */
	public void setDataElementNameValueTable(Hashtable dataElementNameValueTable) {
		this.dataElementNameValueTable = dataElementNameValueTable;
	}
	/**
	 * @return Returns the generationTypeCd.
	 */
	public String getGenerationTypeCd() {
		return generationTypeCd;
	}
	/**
	 * @param generationTypeCd The generationTypeCd to set.
	 */
	public void setGenerationTypeCd(String generationTypeCd) {
		this.generationTypeCd = generationTypeCd;
	}
	/**
	 * @return Returns the incomeYear.
	 */
	public String getIncomeYear() {
		return incomeYear;
	}
		/**
	 * @param incomeYear The incomeYear to set.
	 */
	public void setIncomeYear(String incomeYear) {
		this.incomeYear = incomeYear;
	}
	/**
	 * @return Returns the isSecurityOverride.
	 */
	public boolean getIsSecurityOverride() {
		return isSecurityOverride;
	}
	/**
	 * @param isSecurityOverride The isSecurityOverride to set.
	 */
	public void setIsSecurityOverride(boolean isSecurityOverride) {
		this.isSecurityOverride = isSecurityOverride;
	}
	/**
	 * @return Returns the logUpdateIsRequired.
	 */
	public boolean getLogUpdateIsRequired() {
		return logUpdateIsRequired;
	}
	/**
	 * @param logUpdateIsRequired The logUpdateIsRequired to set.
	 */
	public void setLogUpdateIsRequired(boolean logUpdateIsRequired) {
		this.logUpdateIsRequired = logUpdateIsRequired;
	}
	/**
	 * @return Returns the mailType.
	 */
	public LetterTriggerEvent.MailType getMailType() {
		return mailType;
	}
	/**
	 * @param mailType The mailType to set.
	 */
	public void setMailType(LetterTriggerEvent.MailType mailType) {
		this.mailType = mailType;
	}
	/**
	 * origination type 01=auto, 02=manual, 03=remail
	 * @return Returns the originationType.
	 */
	public String getOriginationType() {
		return originationType;
	}
	/**
	 * @param originationType The originationType to set.
	 */
	public void setOriginationType(String originationType) {
		this.originationType = originationType;
	}
	/**
	 * @return Returns the origTemplate.
	 */
	public CommsTemplate getOrigTemplate() {
		return origTemplate;
	}
	/**
	 * @param origTemplate The origTemplate to set.
	 */
	public void setOrigTemplate(CommsTemplate origTemplate) {
		this.origTemplate = origTemplate;
	}
	/**
	 * This will override the value in the template
	 * values are 01=AAC, 02=HEC, 03=local copy
	 * @return Returns the printLocationCd.
	 */
	public String getPrintLocationCd() {
		return printLocationCd;
	}
	/**
	 * @param printLocationCd The printLocationCd to set.
	 */
	public void setPrintLocationCd(String printLocationCd) {
		this.printLocationCd = printLocationCd;
	}
	/**
	 * The rendered print lines from the formatter
	 * @return Returns the results.
	 */
	public List getResults() {
		return results;
	}
	/**
	 * @param results The results to set.
	 */
	public void setResults(List results) {
		this.results = results;
	}
	/**
	 * @return Returns the ruleClient.
	 */
/*	public GenerationRuleClient getRuleClient() {
		return ruleClient;
	}
*/	/**
	 * @param ruleClient The ruleClient to set.
	 */
/*	public void setRuleClient(GenerationRuleClient ruleClient) {
		this.ruleClient = ruleClient;
	}
*/	
	/**
	 * @return Returns the transmission.
	 */
	public ITransmission getTransmission() {
		return transmission;
	}
	/**
	 * @param transmission The transmission to set.
	 */
	public void setTransmission(ITransmission transmission) {
		this.transmission = transmission;
	}
	/**
	 * @return Returns the partyId.
	 */
	public Person getPerson() {
		return person;
	}
	/**
	 * @param veteranId The partyId to set.
	 */
	public void setPartyId(Person person) {
		this.person = person;
	}
	/**
	 * @return Returns the workloadId.
	 */
	public BigDecimal getWorkloadId() {
		return workloadId;
	}
	/**
	 * @param workloadId The workloadId to set.
	 */
	public void setWorkloadId(BigDecimal workloadId) {
		this.workloadId = workloadId;
	}
	
	/*
	 * FTI Audit Log required
	 */ 
	/**
	 * @return Returns the appUserName.
	 */
	public String getAppUserName() {
		return appUserName;
	}
	/**
	 * @param appUserName The appUserName to set.
	 */
	public void setAppUserName(String appUserName) {
		this.appUserName = appUserName;
	}
	/**
	 * @return Returns the ipAddress.
	 */
	public String getIpAddress() {
		return ipAddress;
	}
		/**
	 * @param ipAddress The ipAddress to set.
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}
	/**
	 * @return Returns the loginDate.
	 */
	public Date getLoginDate() {
		return loginDate;
	}
		/**
	 * @param loginDate The loginDate to set.
	 */
	public void setLoginDate(Date loginDate) {
		this.loginDate = loginDate;
	}
	 
	/**
     * @return Returns the aacExtractId.
     */
    public String getAacExtractId() {
        return aacExtractId;
    }
    /**
     * @param aacExtractId The aacExtractId to set.
     */
    public void setAacExtractId(String aacExtractId) {
        this.aacExtractId = aacExtractId;
    }
//--------------------------------------------------------------------
	// Static method(s)
	//--------------------------------------------------------------------





	//--------------------------------------------------------------------
	// Public method(s)
	//--------------------------------------------------------------------



	/// <summary>
	/// Property for mail type values
	/// </summary>
	public boolean getIsRemail()
	{
		if ( mailType == LetterTriggerEvent.REMAIL_MAIL)
			return true;
		else
			return false;
	}


	/// <summary>
	/// Property for mail type values
	/// </summary>
	public boolean getIsHistoricMail()
	{
		if ( mailType == LetterTriggerEvent.HISTORIC_MAIL)
			return true;
		else
			return false;
	}

	//[Obsolete ("this should not be used")]
	public boolean getSholdGetTemplateFromLogId()
	{
		boolean flag = false;
		if ( mailType == LetterTriggerEvent.REMAIL_MAIL || mailType == LetterTriggerEvent.HISTORIC_MAIL )
			flag = true;
		return flag;
	}


	//--------------------------------------------------------------------
	// Protected method(s)
	//--------------------------------------------------------------------





	//--------------------------------------------------------------------
	// Private method(s)
	//--------------------------------------------------------------------





	//--------------------------------------------------------------------
	// All non-static attributes
	//--------------------------------------------------------------------


	/// <summary>
	/// commsTemplateId key for the current template
	/// </summary>
	private String commsTemplateId = null;

	/// <summary>
	/// the person
	/// </summary>
	private Person person = null;

	/// <summary>
	/// printLocationCd print destination, if set overrides the template's mail center 
	/// </summary>
	private String printLocationCd = null;

	/// <summary>
	/// logUpdateIsRequired indicates if this is a test print or 
	/// to be sent & logged
	/// </summary>
	private boolean logUpdateIsRequired = false;
	
	/// <summary>
	/// indicates whether this letter request has been sent
	/// previously
	/// </summary>
	private boolean isRemail = false;

	/// <summary>
	/// indicates whether this letter request should have do a rules override
	/// if the user has the right permissions they can override the rules
	/// </summary>
	private boolean isSecurityOverride = false;

	/// <summary>
	/// comms log entry
	/// </summary>
	private CommsLogEntry commsLog  = null;

	/// <summary>
	/// workloadId key for the workload entry
	/// </summary>
	private BigDecimal workloadId = null;

	/// <summary>
	/// incomeYear the income year for the financial info
	/// </summary>
	private String incomeYear = null;

	/// <summary>
	/// caseNumber workload case id
	/// </summary>
	private String caseNumber = null;

	/*
	 *  FTI Audit log required filed
	 */
	/// <summary>
	/// The Application User Name that the user uses to login to the system
	/// </summary>
	private String appUserName = null;

	/// <summary>
	/// The IP address of the user's client machine
	/// </summary>
	private String ipAddress = null;

	/// <summary>
	/// The Date when the user log in
	/// </summary>
	private Date loginDate;

	/// <summary>
	/// instance of the transmission if it has been instantiated
	/// </summary>
	private ITransmission transmission = null;

	/// <summary>
	/// instance of the template if it has been instantiated 
	/// </summary>
	private	CommsTemplate origTemplate = null;

	/// <summary>
	/// instance of the rule client if it has been instantiated
	/// </summary>
//	private GenerationRuleClient ruleClient = null;

	/// <summary>
	/// return results
	/// </summary>
	private List results;

	/// <summary>
	/// letter origination type
	/// </summary>
	private String originationType;

	private LetterTriggerEvent.MailType mailType;
	
		/// <summary>
	/// Key value for CommsEvent entries, used only
	/// by the automatic letter generation process
	/// </summary>
	private String commsEventId = null;

	/// <summary>
	/// indicates Auto, manual or remail
	/// </summary>
	private String generationTypeCd = null;

	private String formNumber = null;
	private Hashtable dataElementNameValueTable = null;
	
	private String aacExtractId = null;
	private String categoryType;
  
    /**
     * @return Returns the formNumber.
     */
    public String getFormNumber() {
        return formNumber;
    }
    /**
     * @param formNumber The formNumber to set.
     */
    public void setFormNumber(String formNumber) {
        this.formNumber = formNumber;
    }

	/**
	 * @return Returns the categoryType.
	 */
	public String getCategoryType() {
		return categoryType;
	}

	/**
	 * @param categoryType The categoryType to set.
	 */
	public void setCategoryType(String categoryType) {
		this.categoryType = categoryType;
	}
}  //  End of GenerateValues Class


