/*
 * Created on Feb 1, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.common.builder.comms;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.util.LetterFormatHelper;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.Diagnosis;
import gov.va.med.fw.util.DateUtils;
/**
 * @author DNS   TSAIG
 *
 * TODO:
 */
public class EnrollRemoteFormatter extends AbstractLetterFormatter {
	private static final String RX_COPAY_TEXT = "RX COPAY = NOT EXEMPT";

	private static final String MT_COPAY_TEXT = "MT COPAY = NOT EXEMPT";

	private static final String GMT_COPAY_TEXT = "GMT COPAY = NOT EXEMPT";
 
    
      private static final String EXTENDED_CARE_TEXT="EXT";
        private static final String AGENT_ORANGE_TEXT="AO";
        private static final String WOMEN_VETERANS_SERVICES_TEXT="WVW";
        private static final String POW_REGISTRY_TEXT="POW";
        private static final String PROJECT_112_SHAD_PARTICIPANTS_TEXT ="SHAD";
        private static final String COMBAT_VETERAN_ELIGIBILITY_TEXT="COMB"; 
        private static final String FOREIGN_MEDICAL_PROGRAM_TEXT="FMP";
        private static final String EMERGENCY_CARE_IN_NON_VA_FAC_TEXT="EMER";
        private static final String MILL_BILL_EMERGENCY_CARE_IN_NON_VA_FAC_TEXT="MILL";
        private static final String BENEFICIARY_TRAVEL_TEXT="TRVL";
        private static final String DOMICILLARY_CARE_TEXT="DOM";
        private static final String NURSING_HOME_CARE_TEXT="NUR";
        private static final String COPAY_EXEMPT_INCOME_TEXT="CPYI";
        private static final String COPAY_EXEMPT_ELIGIBILITY_TEXT="CPYE";
        private static final String GMT_COPAY_TEXT_H="GMT";
        private static final String MT_COPAY_TEXT_H="MT";
        private static final String RX_COPAY_EXEMPT_TEXT="RX";
        private static final String RX_COPAY_EXEMPT_SC_TEXT="RXSC";
        private static final String IR_EXPOSURE_REGISTRY_TEXT="IR";
        private static final String NOSE_OR_THROAT_RADIUM_TREATMENT_TEXT="NTR";
        private static final String BLIND_VETERANS_SERVICES="BLND";
        private static final String PERSIAN_GULF_REGISTRY_TEXT="PGR";    
        private static final String READJUSTMENT_COUNDELING_TEXT="RADJ";
        
	// TODO: change this Singleton approach to be the Spring way
	private static IFormatter instance = new EnrollRemoteFormatter();

	public static IFormatter getInstance() {
		return instance;
	}

	private EnrollRemoteFormatter() {
	}

	/*
	 * private String formatEnrollPoa(GenerateValues inputValues) {
	 * EnrollTransmission transmission = (EnrollTransmission) inputValues
	 * .getTransmission();
	 *
	 * CommsTemplate template = inputValues.getOrigTemplate(); AddressType
	 * addressType = transmission.getVeteranAddressType();
	 *
	 * if (transmission == null || template == null) return null; return new
	 * StringBuffer("*FORM=").append(
	 * LetterFormatHelper.toAACFormNumber(template
	 * .getCommsTemplateFormNumber())).append(FIELD_DELIMITER) . //
	 * append("*VER=").append(LetterFormatHelper.toAACVerNumber(template.getAACVersionNumber()))).append(FIELD_DELIMITER).
	 * append("*VER=").append(
	 * LetterFormatHelper.toAACVerNumber(VERSION)).append(
	 * FIELD_DELIMITER).append("* A00=").append(
	 * transmission.getVeteranTitle()).append(FIELD_DELIMITER) .append("*
	 * A01=").append(transmission.getVeteranLastName())
	 * .append(FIELD_DELIMITER).append("* A02=").append(
	 * transmission.getVeteranFirstName()).append( FIELD_DELIMITER).append("*
	 * A03=").append( transmission.getVeteranMiddleName()).append(
	 * FIELD_DELIMITER).append("* A04=").append(
	 * transmission.getVeteranSuffix()) .append(FIELD_DELIMITER).append("*
	 * A15=").append( LetterFormatHelper.toAACSsn(transmission
	 * .getVeteranSsn())).append(FIELD_DELIMITER) .append("*
	 * A16=").append(transmission.getVeteranGender())
	 * .append(FIELD_DELIMITER).append("* A17=").append(
	 * LetterFormatHelper.toAACDate(transmission
	 * .getVeteranDOB())).append(FIELD_DELIMITER) .append("*
	 * B01=").append(transmission.getCaseNumber()).append(
	 * FIELD_DELIMITER).append("* B02=").append(
	 * transmission.getPOA().getAddress().getLine1()).append(
	 * FIELD_DELIMITER).append("* B03=").append(
	 * transmission.getPOA().getAddress().getLine2()).append(
	 * FIELD_DELIMITER).append("* B04=").append(
	 * transmission.getPOA().getAddress().getCity()).append(
	 * FIELD_DELIMITER).append("* B05=").append(
	 * transmission.getPOA().getAddress().getState()).append(
	 * FIELD_DELIMITER).append("* B06=").append(
	 * transmission.getPOA().getAddress().getZipCode())
	 * .append(FIELD_DELIMITER).append("* B07=").append(
	 * transmission.getPOA().getAddress().getCounty()).append(
	 * FIELD_DELIMITER).append("* B08=").append(
	 * transmission.getVeteranHomeTelephoneNumber()).append(
	 * FIELD_DELIMITER).append("* B09=").append(
	 * transmission.getVeteranWorkTelephoneNumber()).append( FIELD_DELIMITER). //
	 * append("* //
	 * B10=").append(transmission.getVeteranCountry())).append(FIELD_DELIMITER).
	 * append("* C01=").append(transmission.getIncomeYear()).append(
	 * FIELD_DELIMITER).append("* C02=").append(
	 * transmission.getCurrentRepresentative()).append(
	 * FIELD_DELIMITER).append("* C03=").append(
	 * transmission.getCurrentRepresentativeTelephone())
	 * .append(FIELD_DELIMITER).append("* C04=").append(EMPTY_STRING)
	 * .append(FIELD_DELIMITER). // init date sent, per AAC not being // used
	 * append("* C05=").append(EMPTY_STRING).append(FIELD_DELIMITER). //
	 * centralized // anniversary // date // n/a // for // 3.0 append("*
	 * C06=").append( LetterFormatHelper.toAACDate(transmission
	 * .getMTDateTimeCompleted())).append( FIELD_DELIMITER). // append("* //
	 * C07=").append(LetterFormatHelper.toAACDate(transmission.getTodayPlus60()))).append(FIELD_DELIMITER). //
	 * append("* //
	 * C08=").append(LetterFormatHelper.toAACDate(transmission.getTodayPlus30()))).append(FIELD_DELIMITER). //
	 * append("* //
	 * C10=").append(LetterFormatHelper.toAACDate(transmission.getLetter601C60DayDate()))).append(FIELD_DELIMITER). //
	 * append("* //
	 * C11=").append(LetterFormatHelper.toAACDate(transmission.getLetter624A30DayDate()))).append(FIELD_DELIMITER). //
	 * append("* //
	 * C12=").append(LetterFormatHelper.toAACDate(transmission.getLetter624A60DayDate()))).append(FIELD_DELIMITER). //
	 * append("* //
	 * C13=").append(LetterFormatHelper.toAACDate(transmission.getLetter625A30DayDate()))).append(FIELD_DELIMITER). //
	 * append("* //
	 * C14=").append(LetterFormatHelper.toAACDate(transmission.getLetter625A60DayDate()))).append(FIELD_DELIMITER).
	 * append("* D01=").append(
	 * transmission.getPrimaryVACareFacilityNumber()).append(
	 * FIELD_DELIMITER).append("* D02=").append(
	 * transmission.getUserNumber()).append(FIELD_DELIMITER). // user // number
	 * append("* D03=").append(transmission.getEligibilityCode())
	 * .append(FIELD_DELIMITER).append("* E01=").append(
	 * transmission.getPreferredFacilityNumber()).append(
	 * FIELD_DELIMITER).append("* E02=").append(
	 * transmission.getVisn()).append(FIELD_DELIMITER).append( "* E03=").append(
	 * transmission.getEnrollmentPriorityLevel()).append(
	 * FIELD_DELIMITER).append("* E04=").append( (new
	 * SimpleDateFormat("MMddyyyy")).format(new Date()))
	 * .append(FIELD_DELIMITER). // date of extract, filled in during // batch
	 * processing append("* E05=").append(
	 * LetterFormatHelper.toAACDate(transmission
	 * .getEnrollmentEndDate())).append( FIELD_DELIMITER).append("*
	 * E06=").append( LetterFormatHelper.toAACDate(transmission
	 * .getEffectiveChangeDate())).append( FIELD_DELIMITER).append("*
	 * E07=").append( transmission.getEnrollmentCategoryCode()).append(
	 * FIELD_DELIMITER).append("* E08=").append(
	 * LetterFormatHelper.toAACDate(transmission .getEgtEffectiveDate()))
	 * .append(FIELD_DELIMITER).append("* E09=").append(
	 * transmission.getEgtSetting()).append(FIELD_DELIMITER) .append("*
	 * E10=").append(inputValues.getAacExtractId()).append( FIELD_DELIMITER). //
	 * extract id append("* E11=").append(EMPTY_STRING).append(FIELD_DELIMITER). //
	 * log // (bar // code) // id // append("* //
	 * E12=").append(transmission.getPreferredFacility())).append(FIELD_DELIMITER). //
	 * append("* //
	 * E13=").append(transmission.getPreferredFacilityAddrLine1())).append(FIELD_DELIMITER). //
	 * append("* //
	 * E14=").append(transmission.getPreferredFacilityAddrLine2())).append(FIELD_DELIMITER). //
	 * append("* //
	 * E15=").append(transmission.getPreferredFacilityAddrCity())).append(FIELD_DELIMITER). //
	 * append("* //
	 * E16=").append(transmission.getPreferredFacilityAddrState())).append(FIELD_DELIMITER). //
	 * append("* //
	 * E17=").append(transmission.getPreferredFacilityAddrZip())).append(FIELD_DELIMITER). //
	 * append("* //
	 * E18=").append(transmission.getPreferredFacilityAddrCountry())).append(FIELD_DELIMITER). //
	 * //Preferred Facility country append("* E19=").append(
	 * transmission.getEnrollmentPriorityLevel()).append(
	 * FIELD_DELIMITER).append("* F01=").append(EMPTY_STRING)
	 * .append(FIELD_DELIMITER). // poa name (first last) append("*
	 * F02=").append(EMPTY_STRING).append(FIELD_DELIMITER). // form // number
	 * append("* F03=").append(EMPTY_STRING).append(FIELD_DELIMITER). // version //
	 * of // form // for // the // veteran // letter append("*
	 * F04=").append(transmission.getVeteranAddressLine1())
	 * .append(FIELD_DELIMITER). // poa append("*
	 * F05=").append(transmission.getVeteranAddressLine2())
	 * .append(FIELD_DELIMITER). // poa append("*
	 * F06=").append(transmission.getVeteranCity()).append( FIELD_DELIMITER). //
	 * poa append("* F07=").append(transmission.getVeteranState()).append(
	 * FIELD_DELIMITER). // poa append("*
	 * F08=").append(transmission.getVeteranZipCode()) .append(FIELD_DELIMITER). //
	 * poa append("* F09=").append(transmission.getVeteranCountry())
	 * .append(FIELD_DELIMITER). // poa append("* F10=").append(
	 * LetterFormatHelper.padRight(inputValues.getCommsLog()
	 * .getCommsLogIdString(), 21, ' ')).append( FIELD_DELIMITER). // veteran
	 * log id // append("* //
	 * G01=").append(transmission.getPrimaryVACareFacilityName())).append(FIELD_DELIMITER). //
	 * append("* //
	 * G02=").append(transmission.getPrimaryVACareFacilityAddrLine1())).append(FIELD_DELIMITER). //
	 * append("* //
	 * G03=").append(transmission.getPrimaryVACareFacilityAddrLine2())).append(FIELD_DELIMITER). //
	 * append("* //
	 * G04=").append(transmission.getPrimaryVACareFacilityAddrCity())).append(FIELD_DELIMITER). //
	 * append("* //
	 * G05=").append(transmission.getPrimaryVACareFacilityAddrState()).append(FIELD_DELIMITER). //
	 * append("* //
	 * G06=").append(transmission.getPrimaryVACareFacilityAddrZip())).append(FIELD_DELIMITER). //
	 * append("* //
	 * G07=").append(transmission.getPrimaryVACareFacilityAddrCountry())).append(FIELD_DELIMITER). //
	 * //primary facility country append("*
	 * H01=").append(EMPTY_STRING).append(FIELD_DELIMITER). // SSA // Message, //
	 * for // ssn // letters // only append("*
	 * H02=").append(getRxCopayText(transmission)).append(
	 * FIELD_DELIMITER).append("* H03=").append(
	 * getMtCopayText(transmission)).append(FIELD_DELIMITER) .append("*
	 * H04=").append(getGmtCopayText(transmission)).append(
	 * FIELD_DELIMITER).append("* H05=").append(
	 * transmission.getMedicationCopay()).append( FIELD_DELIMITER). // Income
	 * Threshold Medication Copay append("*
	 * H06=").append(transmission.getIncomeYear()).append( FIELD_DELIMITER). //
	 * means test data year append("* H07=").append(
	 * transmission.getFirst90daysHospitalCopay()).append( FIELD_DELIMITER). //
	 * 1st 90 days Hospital copay append("* H08=").append(
	 * transmission.getAdditional90DaysHospitalCopay())
	 * .append(FIELD_DELIMITER). // Income Threshold additional 90 // day
	 * hospital deductible append("*
	 * H09=").append(transmission.getInpatientPerDiem())
	 * .append(FIELD_DELIMITER). // Incomd Threshold per diem charge append("*
	 * H10=").append(transmission.getSpecialCopay()).append( FIELD_DELIMITER). //
	 * outpatient co-pay threshold for // specialty append("* H11=").append(
	 * transmission.getOutpatientPreventiveCopay()).append( FIELD_DELIMITER). //
	 * outpatient co-pay threshold for // preventive care append("*
	 * H12=").append( transmission.getGmtInpatientFirst90DayCopay()).append(
	 * FIELD_DELIMITER). // GMT inpatient copay 1st 90 days append("*
	 * H13=").append( transmission.getGmtInpatientAdd90DayCopay()).append(
	 * FIELD_DELIMITER). // GMT inpatient copay 1st 90 days append("*
	 * H14=").append(transmission.getGmtPerDiem()).append( FIELD_DELIMITER). //
	 * GMT per diem append("* H15=").append(transmission.getOutpatientCopay())
	 * .append(FIELD_DELIMITER). // outpatient copay for basic care // services
	 *
	 * append("* H16=").append(EMPTY_STRING).append(FIELD_DELIMITER) .append("*
	 * H17=").append(EMPTY_STRING).append(FIELD_DELIMITER) .append("*
	 * H18=").append(EMPTY_STRING).append(FIELD_DELIMITER) .append("*
	 * H19=").append( addressType != null ? addressType.getCode() :
	 * EMPTY_STRING).append(FIELD_DELIMITER).
	 *
	 * toString(); }
	 */

	private String getRxCopayText(EnrollTransmission trans) {
		if (trans != null && trans.getFormNumber() != null) {
			String formNum = trans.getFormNumber();
			if (trans.isRxCopayNonExempt()
					&& (formNum.equals(ComLetterTemplateType.FORM_NUMBER_600C
							.getCode())
							|| formNum.equals(ComLetterTemplateType.FORM_NUMBER_630D
							.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_640A
											.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_600D
											.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_640B
											.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_640C
											.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_640D
											.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_604A
											.getCode()) || formNum
							.equals(ComLetterTemplateType.FORM_NUMBER_604B
									.getCode())))
				return RX_COPAY_TEXT;
		}
		return EMPTY_STRING;
	}

	private String getMtCopayText(EnrollTransmission trans) {
		if (trans != null && trans.getFormNumber() != null) {
			String formNum = trans.getFormNumber();
			if (trans.isMTCopayRequired()
					&& (formNum.equals(ComLetterTemplateType.FORM_NUMBER_600B
							.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_600C
											.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_600D
											.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_640A
											.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_640B
											.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_640D
											.getCode()) || formNum
							.equals(ComLetterTemplateType.FORM_NUMBER_604A
									.getCode())))
				return MT_COPAY_TEXT;
		}
		return EMPTY_STRING;
	}

	private String getGmtCopayText(EnrollTransmission trans) {
		if (trans != null && trans.getFormNumber() != null) {
			String formNum = trans.getFormNumber();
			if (trans.isGMTCopayRequired()
					&& (formNum.equals(ComLetterTemplateType.FORM_NUMBER_600B
							.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_600C
											.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_600D
											.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_640A
											.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_640B
											.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_640D
											.getCode())
							|| formNum
									.equals(ComLetterTemplateType.FORM_NUMBER_604A
											.getCode()) || formNum
							.equals(ComLetterTemplateType.FORM_NUMBER_604B
									.getCode())))
				return GMT_COPAY_TEXT;
		}
		return EMPTY_STRING;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see gov.va.med.esr.common.builder.comms.AbstractLetterFormatter#buildDataElementsC(java.lang.StringBuffer,
	 *      gov.va.med.esr.common.builder.comms.GeneralTransmission,
	 *      gov.va.med.esr.common.builder.comms.GenerateValues)
	 */
	protected void buildDataElementsC(StringBuffer dataElements,
			GeneralTransmission transmission, GenerateValues inputValues) {
		EnrollTransmission enrollTransmission = (EnrollTransmission) transmission;

		dataElements.append("* C01=").append(transmission.getIncomeYear())
				.append(FIELD_DELIMITER).append("* C02=").append(
						transmission.getCurrentRepresentative()).append(
						FIELD_DELIMITER).append("* C03=").append(
						transmission.getCurrentRepresentativeTelephone())
				.append(FIELD_DELIMITER).append("* C04=").append(EMPTY_STRING)
				.append(FIELD_DELIMITER). // init date sent, per AAC not being
				// used
				append("* C05=").append(EMPTY_STRING).append(FIELD_DELIMITER). // centralized
				// anniversary
				// date
				// n/a
				// for
				// 3.0
				append("* C06=").append(
						LetterFormatHelper.toAACDate(enrollTransmission
								.getMTDateTimeCompleted())).append(
						FIELD_DELIMITER);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see gov.va.med.esr.common.builder.comms.AbstractLetterFormatter#buildDataElementsD(java.lang.StringBuffer,
	 *      gov.va.med.esr.common.builder.comms.GeneralTransmission,
	 *      gov.va.med.esr.common.builder.comms.GenerateValues)
	 */
	protected void buildDataElementsD(StringBuffer dataElements,
			GeneralTransmission transmission, GenerateValues inputValues) {
		EnrollTransmission enrollTransmission = (EnrollTransmission) transmission;

		dataElements.append("* D01=").append(
				enrollTransmission.getPrimaryVACareFacilityNumber()).append(
				FIELD_DELIMITER).append("* D02=").append(
				transmission.getUserNumber()).append(FIELD_DELIMITER). // user
				// number
				append("* D03=")
				.append(enrollTransmission.getEligibilityCode()).append(
						FIELD_DELIMITER);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see gov.va.med.esr.common.builder.comms.AbstractLetterFormatter#buildDataElementsH(java.lang.StringBuffer,
	 *      gov.va.med.esr.common.builder.comms.GeneralTransmission,
	 *      gov.va.med.esr.common.builder.comms.GenerateValues)
	 */
	protected void buildDataElementsH(StringBuffer dataElements,
			GeneralTransmission transmission, GenerateValues inputValues) {
		EnrollTransmission enrollTransmission = (EnrollTransmission) transmission;
		AddressType addressType = transmission.getVeteranAddressType();

		dataElements.append("* H01=").append(EMPTY_STRING).append(
				FIELD_DELIMITER). // SSA
				// Message,
				// for
				// ssn
				// letters
				// only
				append("* H02=").append(getRxCopayText(enrollTransmission))
				.append(FIELD_DELIMITER).append("* H03=").append(
						getMtCopayText(enrollTransmission)).append(
						FIELD_DELIMITER).append("* H04=").append(
						getGmtCopayText(enrollTransmission)).append(
						FIELD_DELIMITER).append("* H05=").append(
						enrollTransmission.getMedicationCopay()).append(
						FIELD_DELIMITER). // Income Threshold Medication Copay
				append("* H06=").append(transmission.getIncomeYear()).append(
						FIELD_DELIMITER). // means test data year
				append("* H07=").append(
						enrollTransmission.getFirst90daysHospitalCopay())
				.append(FIELD_DELIMITER). // 1st 90 days Hospital copay
				append("* H08=").append(
						enrollTransmission.getAdditional90DaysHospitalCopay())
				.append(FIELD_DELIMITER). // Income Threshold additional 90
				// day hospital deductible
				append("* H09=").append(
						enrollTransmission.getInpatientPerDiem()).append(
						FIELD_DELIMITER). // Incomd Threshold per diem charge
				append("* H10=").append(enrollTransmission.getSpecialCopay())
				.append(FIELD_DELIMITER). // outpatient co-pay threshold for
				// specialty
				append("* H11=").append(
						enrollTransmission.getOutpatientPreventiveCopay())
				.append(FIELD_DELIMITER). // outpatient co-pay threshold for
				// preventive care
				append("* H12=").append(
						enrollTransmission.getGmtInpatientFirst90DayCopay())
				.append(FIELD_DELIMITER). // GMT inpatient copay 1st 90 days
				append("* H13=").append(
						enrollTransmission.getGmtInpatientAdd90DayCopay())
				.append(FIELD_DELIMITER). // GMT inpatient copay 1st 90 days
				append("* H14=").append(enrollTransmission.getGmtPerDiem())
				.append(FIELD_DELIMITER). // GMT per diem
				append("* H15=")
				.append(enrollTransmission.getOutpatientCopay()).append(
						FIELD_DELIMITER). // outpatient copay for basic care
				// services
				append("* H16=").append(EMPTY_STRING).append(FIELD_DELIMITER)
				.append("* H17=").append(EMPTY_STRING).append(FIELD_DELIMITER)
				.append("* H18=").append(EMPTY_STRING).append(FIELD_DELIMITER)
				.append("* H19=").append(
						addressType != null ? addressType.getCode()
								: EMPTY_STRING).append(FIELD_DELIMITER);
        

	}

	/*
	 * (non-Javadoc)
	 *
	 * @see gov.va.med.esr.common.builder.comms.AbstractLetterFormatter#buildDataElementsE(java.lang.StringBuffer,
	 *      gov.va.med.esr.common.builder.comms.GeneralTransmission,
	 *      gov.va.med.esr.common.builder.comms.GenerateValues)
	 */
	protected void buildDataElementsE(StringBuffer dataElements,
			GeneralTransmission transmission, GenerateValues inputValues, Association poa) {
		EnrollTransmission enrollTransmission = (EnrollTransmission) transmission;

		String barCode = poa != null ? LetterFormatHelper.BARCODE_POA_TOKEN : getBarcode(inputValues);

		dataElements.append("* E01=").append(
				enrollTransmission.getPreferredFacilityNumber()).append(
				FIELD_DELIMITER).append("* E02=")
				.append(transmission.getVisn()).append(FIELD_DELIMITER).append(
						"* E03=").append(
						enrollTransmission.getCurrentEnrollmentPriorityLevel())
				.append(FIELD_DELIMITER).append("* E04=").append(
						(new SimpleDateFormat("MMddyyyy")).format(new Date()))
				.append(FIELD_DELIMITER). // date of extract, filled in during
				// batch processing
				append("* E05=").append(
						LetterFormatHelper.toAACDate(enrollTransmission
								.getEnrollmentEndDate())).append(
						FIELD_DELIMITER).append("* E06=").append(
						LetterFormatHelper.toAACDate(enrollTransmission
								.getEffectiveChangeDate())).append(
						FIELD_DELIMITER).append("* E07=").append(
						enrollTransmission.getEnrollmentCategoryCode()).append(
						FIELD_DELIMITER).append("* E08=").append(
						LetterFormatHelper.toAACDate(enrollTransmission
								.getEgtEffectiveDate()))
				.append(FIELD_DELIMITER).append("* E09=").append(
						enrollTransmission.getEgtSetting()).append(
						FIELD_DELIMITER).append("* E10=").append(
						inputValues.getAacExtractId()).append(FIELD_DELIMITER). // extract
																				// id
				append("* E11=").append(barCode)
				.append(FIELD_DELIMITER). // log (bar code) id
				append("* E19=").append(
						enrollTransmission.getMostRecentNonNullPriorityLevel())
				.append(FIELD_DELIMITER);
	}
	
	private boolean isVeteran(Person person)
	{
		if (person == null || person.isVeteran() == null)
			return false;
		
		return person.isVeteran().booleanValue();
	}
      protected void buildDataElementsH20(StringBuffer dataElements,
              GeneralTransmission transmission, GenerateValues inputValues, Person person) {
           Date currentDate = DateUtils.getCurrentDate();
          Integer incomeYear = person.getLatestIncomeYear();
          IncomeTest incomeTest =(IncomeTest)person.getIncomeTest(incomeYear);
          ServiceConnectionAward serviceConnectionAward =(ServiceConnectionAward)person.getServiceConnectionAward();
          MilitaryService militaryService = (person != null) ? person.getMilitaryService() : null;
          dataElements.append("* H20=");
          boolean isVeteran = isVeteran(person);
          
        if(isVeteran && person.getAgentOrangeExposure() != null && 
        		(person.getAgentOrangeExposure().getAgentOrangeExposureIndicator() != null && 
        				Indicator.YES.getCode().equalsIgnoreCase(person.getAgentOrangeExposure().getAgentOrangeExposureIndicator().getCode()) ) &&
        		( person.getAgentOrangeExposure().getLocation() != null && 
        				((AgentOrangeExposureLocation.CODE_VIETNAM.getCode().equals(person.getAgentOrangeExposure().getLocation().getCode())) || 
        				 (AgentOrangeExposureLocation.CODE_KOREAN_DMZ.getCode().equals(person.getAgentOrangeExposure().getLocation().getCode())) ||
        				 (AgentOrangeExposureLocation.CODE_OTHER.getCode().equals(person.getAgentOrangeExposure().getLocation().getCode()))
        				)
        		)
        ){
            dataElements.append(AGENT_ORANGE_TEXT);
        }
        if(isVeteran){
            checkForFieldSeparator(dataElements);
            dataElements.append(EXTENDED_CARE_TEXT);;
        }
        if(isVeteran && person.getGender() !=null && Gender.FEMALE.getCode().equals(person.getGender().getCode())){
            checkForFieldSeparator(dataElements);
            dataElements.append(WOMEN_VETERANS_SERVICES_TEXT); 
        }
        if(isVeteran && person.getPrisonerOfWar() !=null && person.getPrisonerOfWar().getPowIndicator() != null &&
        		Indicator.YES.getCode().equals(person.getPrisonerOfWar().getPowIndicator().getCode())){
            checkForFieldSeparator(dataElements);
            dataElements.append(POW_REGISTRY_TEXT); 
        }
        if(isVeteran &&person.getShad()!=null &&  person.getShad().getShadIndicator() != null &&
        		Indicator.YES.getCode().equals(person.getShad().getShadIndicator().getCode())){
            checkForFieldSeparator(dataElements);
            dataElements.append(PROJECT_112_SHAD_PARTICIPANTS_TEXT); 
        }
        if(isVeteran && militaryService!=null &&  militaryService.getCombatServices() != null 
                && militaryService.getCombatVeteranEligibilityEndDate() !=null && militaryService.getCombatVeteranEligibilityEndDate().after(currentDate)){
            checkForFieldSeparator(dataElements);
            dataElements.append(COMBAT_VETERAN_ELIGIBILITY_TEXT); 
        }
        if(isVeteran && serviceConnectionAward !=null && serviceConnectionAward.getServiceConnectedIndicator() !=null && 
                serviceConnectionAward.getServiceConnectedIndicator().booleanValue() && person.getMonetaryBenefitAward() !=null &&
                person.getMonetaryBenefitAward().getDisabilityCompensation() != null && 
                //ccr 10082 added more null check
                person.getMonetaryBenefitAward().getDisabilityCompensation().getMonetaryBenefitIndicator() !=null &&
                Indicator.YES.getCode().equals(person.getMonetaryBenefitAward().getDisabilityCompensation().getMonetaryBenefitIndicator().getCode())){
            checkForFieldSeparator(dataElements);
            dataElements.append(FOREIGN_MEDICAL_PROGRAM_TEXT); 
        }
        if(isVeteran && serviceConnectionAward !=null && serviceConnectionAward.getServiceConnectedIndicator() != null &&
                serviceConnectionAward.getServiceConnectedIndicator().booleanValue()){
            checkForFieldSeparator(dataElements);
            dataElements.append(EMERGENCY_CARE_IN_NON_VA_FAC_TEXT); 
        }
        //ccr 10082 added more null check
        if(isVeteran && person.isEnrolled()&& serviceConnectionAward !=null && serviceConnectionAward.getServiceConnectedIndicator() != null &&
               !serviceConnectionAward.getServiceConnectedIndicator().booleanValue()){ 
            checkForFieldSeparator(dataElements);
            dataElements.append(MILL_BILL_EMERGENCY_CARE_IN_NON_VA_FAC_TEXT); 
        }
        if((serviceConnectionAward !=null && serviceConnectionAward.getServiceConnectedPercentage() !=null && 
        		serviceConnectionAward.getServiceConnectedPercentage().intValue()>30) ||
        	(person.getMonetaryBenefitAward() !=null && person.getMonetaryBenefitAward().getVAPension() !=null )||(incomeTest !=null && 
        		//ccr 10082 added more null check
        		incomeTest.getPensionThreshold() !=null && incomeTest.getTotalIncome() !=null && incomeTest.getTotalIncome().intValue()<
                incomeTest.getPensionThreshold().intValue())){
        		checkForFieldSeparator(dataElements);
        		dataElements.append(BENEFICIARY_TRAVEL_TEXT); 
        }
        //ccr 10082 added more null check
        else if(serviceConnectionAward !=null && ( serviceConnectionAward.getServiceConnectedPercentage() !=null && 
                serviceConnectionAward.getServiceConnectedPercentage().intValue()<30 
            && person.getMonetaryBenefitAward() !=null && person.getMonetaryBenefitAward().getVAPension()!=null) && 
            (incomeTest !=null  && incomeTest.getTotalIncome() !=null && incomeTest.getPensionThreshold() !=null && 
                    incomeTest.getTotalIncome().intValue()>incomeTest.getPensionThreshold().intValue())){
        		checkForFieldSeparator(dataElements);
            dataElements.append(BENEFICIARY_TRAVEL_TEXT); 
            }
        if(((isVeteran) && incomeTest !=null && incomeTest.getTotalIncome() !=null &&
               ( (incomeTest.getPensionThreshold()!=null &&incomeTest.getTotalIncome().intValue()< incomeTest.getPensionThreshold().intValue()) ||
                         incomeTest.getHardship() !=null && incomeTest.getHardship().getHardshipGranted().booleanValue()))){
            checkForFieldSeparator(dataElements);
            dataElements.append(DOMICILLARY_CARE_TEXT); 
        }
                
        if(isVeteran && serviceConnectionAward !=null && serviceConnectionAward.getServiceConnectedPercentage() != null && 
                (serviceConnectionAward.getServiceConnectedPercentage().intValue()>70 ||
                (serviceConnectionAward.getServiceConnectedPercentage().intValue()>60 &&
                        ( serviceConnectionAward.getUnemployable() !=null && serviceConnectionAward.getUnemployable().booleanValue()) 
                        ||( serviceConnectionAward.isPermanentAndTotal() !=null && serviceConnectionAward.isPermanentAndTotal().booleanValue())))){
            checkForFieldSeparator(dataElements);
            dataElements.append(NURSING_HOME_CARE_TEXT); 
        }
        else if(isVeteran&& serviceConnectionAward !=null && (serviceConnectionAward.getServiceConnectedIndicator().booleanValue()
                           &&( serviceConnectionAward.getServiceConnectedPercentage() != null  && serviceConnectionAward.getServiceConnectedPercentage().intValue()<60) &&
                           ( (serviceConnectionAward.getUnemployable() !=null && serviceConnectionAward.getUnemployable().booleanValue()) 
                           ||(serviceConnectionAward.isPermanentAndTotal() !=null && serviceConnectionAward.isPermanentAndTotal().booleanValue())||
                           (serviceConnectionAward.getServiceConnectedPercentage() != null && serviceConnectionAward.getServiceConnectedPercentage().intValue()>70)))){
            checkForFieldSeparator(dataElements);
            dataElements.append(NURSING_HOME_CARE_TEXT); 
        }
        if(isVeteran && incomeTest !=null &&incomeTest.getStatus()!=null &&
        		MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode().equals(incomeTest.getStatus().getCode())){
            checkForFieldSeparator(dataElements);
            dataElements.append(COPAY_EXEMPT_INCOME_TEXT);  
        }
        if(isVeteran &&incomeTest !=null &&
                (incomeTest.getStatus()==null || MeansTestStatus.MT_STATUS_NO_LONGER_REQUIRED.getCode().equals(incomeTest.getStatus().getCode()))){
            checkForFieldSeparator(dataElements);
            dataElements.append(COPAY_EXEMPT_ELIGIBILITY_TEXT);  
        }
        if(isVeteran && incomeTest  !=null && incomeTest.getStatus() != null &&
        		MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getCode().equals(incomeTest.getStatus().getCode())){
            checkForFieldSeparator(dataElements);
            dataElements.append(GMT_COPAY_TEXT_H);  
        }            
        if(isVeteran && incomeTest  !=null && incomeTest.getStatus() != null &&
        		( (MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode().equals(incomeTest.getStatus().getCode())||
        				MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getCode().equals(incomeTest.getStatus().getCode())))){
            checkForFieldSeparator(dataElements);
            dataElements.append(MT_COPAY_TEXT_H);  
        }
       if(isVeteran && incomeTest  !=null && incomeTest.getDeterminedStatus() != null &&
    		   MeansTestStatus.MT_STATUS_EXEMPT.getCode().equals(incomeTest.getDeterminedStatus().getCode())){
           checkForFieldSeparator(dataElements);
           dataElements.append(RX_COPAY_EXEMPT_TEXT);  
        } 
        if(isVeteran && incomeTest !=null && incomeTest.getDeterminedStatus() != null &&
                incomeTest.getDeterminedStatus().getCode().equals(MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode())){
            checkForFieldSeparator(dataElements);
            dataElements.append(RX_COPAY_EXEMPT_SC_TEXT);  
        }
        if(isVeteran && person.getRadiationExposure() !=null && person.getRadiationExposure().getRadiationExposureIndicator() != null &&
                person.getRadiationExposure().getRadiationExposureIndicator().getCode().equals(Indicator.YES.getCode()) &&
               ( person.getRadiationExposure().getExposureMethod() != null && (person.getRadiationExposure().getExposureMethod().getCode()
                .equals(gov.va.med.esr.common.model.lookup.RadiationExposureMethod.CODE_NAGASAKI_HIROSHIMA.getCode()) ||
                person.getRadiationExposure().getExposureMethod().getCode()
                .equals(gov.va.med.esr.common.model.lookup.RadiationExposureMethod.CODE_ATMOSPHERIC_NUCLEAR_TESTING.getCode())||
                person.getRadiationExposure().getExposureMethod().getCode()
                .equals(gov.va.med.esr.common.model.lookup.RadiationExposureMethod.CODE_HN_ATMOSPHERIC_TESTING.getCode())))){
            checkForFieldSeparator(dataElements);
            dataElements.append(IR_EXPOSURE_REGISTRY_TEXT);  
        }
        else if(isVeteran && person.getRadiationExposure() !=null && person.getRadiationExposure().getRadiationExposureIndicator() != null &&
                person.getRadiationExposure().getRadiationExposureIndicator().getCode().equals(Indicator.YES.getCode()) &&
                ( person.getRadiationExposure().getExposureMethod() != null && (person.getRadiationExposure().getExposureMethod().getCode()
                        .equals(gov.va.med.esr.common.model.lookup.RadiationExposureMethod.CODE_UNDERGROUND_NUCLEAR_TESTING.getCode()) ||
                        person.getRadiationExposure().getExposureMethod().getCode()
                        .equals(gov.va.med.esr.common.model.lookup.RadiationExposureMethod.CODE_EXPOSURE_AT_NUCLEAR_FACILITY.getCode())||
                        person.getRadiationExposure().getExposureMethod().getCode()
                        .equals(gov.va.med.esr.common.model.lookup.RadiationExposureMethod.CODE_OTHER.getCode())))){
            checkForFieldSeparator(dataElements);
            dataElements.append(IR_EXPOSURE_REGISTRY_TEXT);  
         }
        if(isVeteran &&person.getNoseThroatRadium()!=null){
            checkForFieldSeparator(dataElements);
            dataElements.append(NOSE_OR_THROAT_RADIUM_TREATMENT_TEXT);  
        }
       if(isVeteran && person.getCatastrophicDisability() !=null && 
               person.getCatastrophicDisability().isCatastrophicallyDisabled() !=null &&
               person.getCatastrophicDisability().isCatastrophicallyDisabled().booleanValue()&& person.getCatastrophicDisability().getDiagnoses() !=null ){
              
           Set diagnoses=person.getCatastrophicDisability().getDiagnoses();
           Iterator iter=diagnoses.iterator();
           while(iter.hasNext()){
                   CDDiagnosis cdDiagnoses=(CDDiagnosis)iter.next();
                   if(cdDiagnoses.getDiagnosis().getCode().equals(Diagnosis.CODE_LEGAL_BLINDNESS.getCode())){
                       checkForFieldSeparator(dataElements);
                       dataElements.append(BLIND_VETERANS_SERVICES); 
                       break;
                   }
           }
       }
      if(isVeteran){
          Set militaryServiceSiteRecords = (militaryService != null) ? militaryService.getMilitaryServiceSiteRecords(): null;
          if (militaryServiceSiteRecords != null&& militaryServiceSiteRecords.size() > 0) {
               Iterator iterMilitaryServiceSiteRecords = militaryServiceSiteRecords.iterator();
               while (iterMilitaryServiceSiteRecords.hasNext()) {
                     MilitaryServiceSiteRecord militaryServiceSiteRecord = (MilitaryServiceSiteRecord) iterMilitaryServiceSiteRecords.next();
                     if (militaryServiceSiteRecord.getServicePeriod() != null
                              && militaryServiceSiteRecord.getServicePeriod().getCode().equals(ServicePeriod.CODE_PERSIAN_GULF_WAR.getCode())) {
                         checkForFieldSeparator(dataElements);
                         dataElements.append(PERSIAN_GULF_REGISTRY_TEXT); 
                                break;
                     }
               }
          }
       }
      if(isVeteran && militaryService != null && militaryService.getCombatServices() != null &&
              militaryService.getCombatVeteranEligibilityEndDate()!=null && militaryService.getCombatVeteranEligibilityEndDate().after(currentDate)){
          checkForFieldSeparator(dataElements);
          dataElements.append(READJUSTMENT_COUNDELING_TEXT); 
       }       
        dataElements.append(FIELD_DELIMITER);    
    }
      private void checkForFieldSeparator(StringBuffer dataElements){
          if (dataElements.lastIndexOf("=")!=dataElements.length()-1){
              dataElements.append(FIELD_SEPARATOR);
          }
      }
      
} // End of EnrollRemoteFormatter Class
