package gov.va.med.esr.common.batchprocess.datasync;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.scheduling.AbstractScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;

public class PersonLoaderProcess extends AbstractScheduledProcess {

    Hashtable persons;

    Hashtable personSites = new Hashtable();

    /*
     * Set of personIds
     */
    Set personKeys;

    int processId;

    private PersonService personService;

    private PSDelegateService psDelegateService;

    /*
     * set this flag to true once all the personIds are processed
     */
    private boolean isComplete = false;

    /**
     * for the all the given personKeys queries the person objects and sites and
     * loads the data into shared Hashtables across all the thereads. Caller
     * will check the person and sites objects in these hash tables before going
     * to the database.
     */
    protected void executeProcess(ScheduledProcessInvocationContext context)
            throws Exception {
        try {
            if (logger.isDebugEnabled() ) {
                logger.debug("executeProcess With processId:" + processId
                        + " And personIds :" + personKeys);

            }
            if (personKeys != null && personKeys.size() > 0) {
                Iterator itr = personKeys.iterator();
                while (itr.hasNext()) {
                    String personId = (String) itr.next();

                    try {
                        PersonEntityKey personEntityKey = CommonEntityKeyFactory
                                .createPersonIdEntityKey(personId);
                        Person person = personService
                                .getPerson(personEntityKey);

                        Set currpersonsites = psDelegateService.getSites(person
                                .getVPIDEntityKey());
                        persons.put(personId, person);
                        personSites.put(person.getVPIDEntityKey(),
                                currpersonsites);

                    } catch (Exception eX) {
                        // log and continue
                        if (logger.isErrorEnabled())
                            logger.error("Unable to load person : " + personId,
                                    eX);
                    }
                }
            }
        } catch (Exception e) {
            // log and continue
            if (logger.isErrorEnabled())
                logger.error("Unable to load persons : " + e);
        } finally {
            isComplete = true;
            if (logger.isDebugEnabled())
                logger.debug("Completed PersonLoaderProcess for processId:" + processId);
            
        }
        return;

    }

    public Set getPersonKeys() {
        return personKeys;
    }

    public void setPersonKeys(Set personKeys) {
        this.personKeys = personKeys;
    }

    public Hashtable getPersons() {
        return persons;
    }

    public Hashtable getPersonSites() {
        return personSites;
    }

    public void setPersonSites(Hashtable personSites) {
        this.personSites = personSites;
    }

    public PSDelegateService getPsDelegateService() {
        return psDelegateService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }

    public void setPersons(Hashtable persons) {
        this.persons = persons;
    }

    public int getProcessId() {
        return processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public PersonService getPersonService() {
        return personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public boolean isComplete() {
        return isComplete;
    }

    public void setComplete(boolean isComplete) {
        this.isComplete = isComplete;
    }

}
