package gov.va.med.esr.common.batchprocess.datasync;

import java.util.Date;
import java.util.List;
import java.util.Map;

import gov.va.med.fw.batchprocess.AcquiredDataProcessor;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.service.AbstractComponent;


/**
 * IVMExtractDateProcessor
 * Created Apr 25, 2006 6:11:02 PM
 * @author DNS   MANSOG
 *
 */
public class IVMExtractDateProcessor extends AbstractComponent implements AcquiredDataProcessor {
    protected static final String IVM_EXTRACT_START_TIME = "IVM_EXTRACT_START_TIME";
    protected static final String IVM_LAST_EXTRACT_TIME = "IVM_LAST_EXTRACT_TIME";

    /**
     * @see gov.va.med.fw.batchprocess.AcquiredDataProcessor#processAcquiredData(gov.va.med.fw.batchprocess.DataProcessExecutionContext, java.util.List)
     */
    public void processAcquiredData(DataProcessExecutionContext context, List acquiredData) throws Exception {
        Map data = context.getContextData();
        if (getExtractStartTime(context) == null || getLastExtractTime(context) == null) {
            Object[] result = (Object[])acquiredData.iterator().next();
            Date extractStartTime = (Date)result[0];
            Date lastExtractDate = (Date)result[1];

            Date lastExtractDateArg = (Date)context.getContextData().get(IVMDataSynchronizationProducerProcess.EXTRACTSTARTDATEARG); 
            if ( lastExtractDateArg != null )
            {
                data.put(IVM_LAST_EXTRACT_TIME, lastExtractDateArg);
            }
            else
            {
                data.put(IVM_LAST_EXTRACT_TIME, lastExtractDate);
            }
            data.put(IVM_EXTRACT_START_TIME, extractStartTime);
            
            if ( logger.isDebugEnabled())
            {
                logger.debug("extractStartTime : " + extractStartTime);
                logger.debug("lastExtractDate : " + lastExtractDate);
                logger.debug("lastExtractDateArg : " + lastExtractDateArg);
            }
        }
    }

    public static Date getLastExtractTime(DataProcessExecutionContext context) {
        Map data = context.getContextData();
        
        Date lastExtractDateArg = (Date)context.getContextData().get(IVMDataSynchronizationProducerProcess.EXTRACTSTARTDATEARG);
        if ( lastExtractDateArg != null )
        {
            return lastExtractDateArg;
        }
        
        return (Date) data.get(IVM_LAST_EXTRACT_TIME);
    }
    public static Date getExtractStartTime(DataProcessExecutionContext context) {
        Map data = context.getContextData();
        return (Date) data.get(IVM_EXTRACT_START_TIME);
    }
}
