/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.esr.service.IVMDMService;
import gov.va.med.fw.batchprocess.AbstractDataFileProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.io.RawFileDataList;
import gov.va.med.fw.util.StringUtils;

import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.Validate;

/**
 * IVMDataSynchronizationExceptionConsumerProcess
 * Created Apr 18, 2006 7:20:28 PM
 * @author DNS   MANSOG
 *
 */
public class IVMDataSynchronizationExceptionConsumerProcess 
        extends AbstractDataFileProcess {

    private IVMDMService ivmDMService;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();     
        Validate.notNull(ivmDMService, "IVMDMService is required.");
    }

    /**
     * @see gov.va.med.fw.batchprocess.AbstractDataProcess#processData(gov.va.med.fw.batchprocess.DataProcessExecutionContext, java.util.List)
     */
    protected void processData(DataProcessExecutionContext context, List acquiredData) {
        Integer incomeYear = null;
        for (Iterator iter = acquiredData.iterator(); iter.hasNext();) {
            try {
                RawFileDataList fileRow = (RawFileDataList) iter.next();
                if (incomeYear == null) {
                    String id = fileRow.size() > 0 ? (String) fileRow.get(0) : null;
                    if (StringUtils.isNotEmpty(id))
                        incomeYear = new Integer(id);
                    continue;
                }
                if (fileRow.size() >= 3) {
                    String icn = (String) fileRow.get(0) ;
                    String date = (String) fileRow.get(1);
                    String errorReason = (String) fileRow.get(2);
                    
                    if (ivmDMService.updateErrorReasonData(incomeYear, icn, date, errorReason)) {
                        context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                        continue;
                    }
                }
                context.getProcessStatistics().incrementNumberOfErrorRecords();
            } catch (Exception ex) {
                context.getExceptionData().add(ex);
                context.getProcessStatistics().incrementNumberOfErrorRecords();
            }
        }
    }

    /**
     * @return Returns the ivmDMService.
     */
    public IVMDMService getIvmDMService() {
        return ivmDMService;
    }
    
    /**
     * @param ivmDMService The ivmDMService to set.
     */
    public void setIvmDMService(IVMDMService ivmDMService) {
        this.ivmDMService = ivmDMService;
    }
}
