/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.esr.common.model.ivmdm.IVMClearLoadErrorStatistics;
import gov.va.med.esr.service.IVMDMService;
import gov.va.med.fw.batchprocess.AbstractDataFileProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.io.RawFileDataList;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;

import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.Validate;

/**
 * IVMDataSynchronizationExceptionConsumerProcess 
 * Created Apr 18, 2006 7:20:28
 * @author DNS   MANSOG
 */
public class IVMDataSynchronizationClearLoadErrorConsumerProcess extends AbstractDataFileProcess {

    private IVMDMService ivmDMService;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull(ivmDMService, "IVMDMService is required.");
    }

    /**
     * @see gov.va.med.fw.batchprocess.AbstractDataProcess#processData(gov.va.med.fw.batchprocess.DataProcessExecutionContext,
     *      java.util.List)
     */
    protected void processData(DataProcessExecutionContext context, List acquiredData) {
        IVMClearLoadErrorStatistics loadErrorStats = null;
        for (Iterator iter = acquiredData.iterator(); iter.hasNext();) {
            RawFileDataList fileRow = (RawFileDataList) iter.next();
            if (fileRow.size() >= 2) {
                String icn = (String) fileRow.get(0);
                String incomeYear = (String) fileRow.get(1);
                if (StringUtils.isNotEmpty(icn) && StringUtils.isNotEmpty(incomeYear)) {
                    try {
                        if (loadErrorStats == null) {
                            loadErrorStats = new IVMClearLoadErrorStatistics();
                        }
                        ivmDMService.updateClearLoadError(icn, incomeYear, loadErrorStats);
                        context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                        continue;
                    } catch (Exception ex) {
                        context.getExceptionData().add(ex);
                        context.getProcessStatistics().incrementNumberOfErrorRecords();
                    }
                }
            }
            context.getProcessStatistics().incrementNumberOfErrorRecords();
        }
        try {
            if (loadErrorStats != null)
                ivmDMService.saveClearLoadErrorStatistics(loadErrorStats);
        } catch (ServiceException ex) {
            throw new IllegalStateException("Error saving the clear load error statistics. Reason: "+ex.getMessage());
        }
    }

    /**
     * @return Returns the ivmDMService.
     */
    public IVMDMService getIvmDMService() {
        return ivmDMService;
    }

    /**
     * @param ivmDMService
     *            The ivmDMService to set.
     */
    public void setIvmDMService(IVMDMService ivmDMService) {
        this.ivmDMService = ivmDMService;
    }
}
