/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.esr.common.model.lookup.County;
import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.io.FieldTransformer;
import gov.va.med.fw.service.AbstractComponent;

import org.apache.commons.lang.StringUtils;

/**
 * Initial javadoc for class HECLegacyCountyCodeTransformer.
 * TODO - Add content here
 * 
 * Created May 19, 2006 3:36:43 PM
 * @author DNS   BOHMEG
 */
public class IVMDataSyncCountyCodeTransformer extends AbstractComponent implements
		FieldTransformer {
	private LookupService lookupService;

	/**
	 * @see gov.va.med.fw.io.FieldTransformer#transformData(java.lang.String, java.lang.Object)
	 */
	public Object transformData(String fieldName, Object data) throws Exception {
		Object transformedValue = StringUtils.EMPTY;
		if(data != null) {
			Address add = (Address) data;
			// if not found via lookupService, send nothing (per ICD)
			//transformedValue = add.getCounty();
			try {
				County county = lookupService.getCountyByAddress(add);
				if(county != null) {
                    State state = county.getState();
                    String fipsCode = state == null 
                                        || state.getFipsCode() == null 
                                      ? "" : state.getFipsCode();
                    transformedValue = fipsCode + county.getCountyNumber();
                }
			} catch(Exception e) {
				if(logger.isInfoEnabled())
					logger.info("Unable to determine the County from Address: " + add);
			}
		}
		return transformedValue;
	}

	/**
	 * @return Returns the lookupService.
	 */
	public LookupService getLookupService() {
		return lookupService;
	}

	/**
	 * @param lookupService The lookupService to set.
	 */
	public void setLookupService(LookupService lookupService) {
		this.lookupService = lookupService;
	}

}
