/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess.datasync;

import org.apache.commons.lang.StringUtils;

import gov.va.med.fw.io.FieldTransformer;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;

import gov.va.med.esr.common.model.security.ESRUserPrincipal;
import gov.va.med.esr.service.UserAdminService;

/**
 * Initial javadoc for class HECLegacyUserFullNameTransformer.
 * TODO - Add content here
 * 
 * Created May 19, 2006 2:02:03 PM
 * @author DNS   BOHMEG
 */
public class HECLegacyUserFullNameTransformer extends AbstractComponent
		implements FieldTransformer {
	private UserAdminService userAdminService;

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.FieldTransformer#transformData(java.lang.String, java.lang.Object)
	 */
	public Object transformData(String fieldName, Object data) throws Exception {
		Object transformedValue = StringUtils.EMPTY;
		
		String username = data != null ? data.toString() : null;		
		if(!StringUtils.isBlank(username)) {
			transformedValue = username;
			try {
				ESRUserPrincipal prin = userAdminService.getUserByName(username);
				if(prin != null)
					transformedValue = prin.getFamilyName() + "," + prin.getGivenName();
			} catch(ServiceException e) {
				if(logger.isWarnEnabled())
					logger.warn("Unable to lookup user to get full name", e);
			}
		}
		return transformedValue;
	}

	/**
	 * @return Returns the userAdminService.
	 */
	public UserAdminService getUserAdminService() {
		return userAdminService;
	}

	/**
	 * @param userAdminService The userAdminService to set.
	 */
	public void setUserAdminService(UserAdminService userAdminService) {
		this.userAdminService = userAdminService;
	}
}
