/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess.datasync;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.PHDataSource;
import gov.va.med.esr.common.model.lookup.PHDocumentType;
import gov.va.med.esr.common.model.lookup.RejectionRemark;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;

/**
 * Initial javadoc for class HECLegacyPurpleHeartFileData.
 * TODO - Add content here
 * 
 * Created Mar 14, 2006 10:16:48 PM
 * @author DNS   BOHMEG
 */
public class HECLegacyPurpleHeartFileData extends AbstractRawFileDataContainer {
	/**
	 * 
	 */
	private static final long serialVersionUID = -8894874411618968836L;
	private String SSN;
	private Name legalName = new Name();
	private String degree;
	private DecorationStatus status;
	private ImpreciseDate statusUpdateDate;
	private RejectionRemark rejectedRemarks;
	private String updateUser;
	private ImpreciseDate updatedDate;
	private PHDocumentType documentType;
	private PHDataSource dataSource;
	private VAFacility site;
	private ImpreciseDate docReceivedDate;
	private ImpreciseDate docLoggedInDate;
	private String documentAcceptable;
	private String unacceptableRemarks;
	private String indicator;
	private String contactRepAssigned;
	
	static {
		RawFileDataContainerUtils.autoRegisterConvertersForClass();
	}
	
	/**
	 * @return Returns the legalName.
	 */
	public Name getLegalName() {
		return legalName;
	}

	/**
	 * @param legalName The legalName to set.
	 */
	public void setLegalName(Name legalName) {
		this.legalName = legalName;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		// TODO Auto-generated method stub

	}

	/**
	 * @return Returns the contactRepAssigned.
	 */
	public String getContactRepAssigned() {
		return contactRepAssigned;
	}

	/**
	 * @param contactRepAssigned The contactRepAssigned to set.
	 */
	public void setContactRepAssigned(String contactRepAssigned) {
		this.contactRepAssigned = contactRepAssigned;
	}

	/**
	 * @return Returns the docLoggedInDate.
	 */
	public ImpreciseDate getDocLoggedInDate() {
		return docLoggedInDate;
	}

	/**
	 * @param docLoggedInDate The docLoggedInDate to set.
	 */
	public void setDocLoggedInDate(ImpreciseDate docLoggedInDate) {
		this.docLoggedInDate = docLoggedInDate;
	}

	/**
	 * @return Returns the docReceivedDate.
	 */
	public ImpreciseDate getDocReceivedDate() {
		return docReceivedDate;
	}

	/**
	 * @param docReceivedDate The docReceivedDate to set.
	 */
	public void setDocReceivedDate(ImpreciseDate docReceivedDate) {
		this.docReceivedDate = docReceivedDate;
	}

	/**
	 * @return Returns the documentAcceptable.
	 */
	public String getDocumentAcceptable() {
		return documentAcceptable;
	}

	/**
	 * @param documentAcceptable The documentAcceptable to set.
	 */
	public void setDocumentAcceptable(String documentAcceptable) {
		this.documentAcceptable = documentAcceptable;
	}

	/**
	 * @return Returns the indicator.
	 */
	public String getIndicator() {
		return indicator;
	}

	/**
	 * @param indicator The indicator to set.
	 */
	public void setIndicator(String indicator) {
		this.indicator = indicator;
	}

	/**
	 * @return Returns the statusUpdateDate.
	 */
	public ImpreciseDate getStatusUpdateDate() {
		return statusUpdateDate;
	}

	/**
	 * @param statusUpdateDate The statusUpdateDate to set.
	 */
	public void setStatusUpdateDate(ImpreciseDate statusUpdateDate) {
		this.statusUpdateDate = statusUpdateDate;
	}

	/**
	 * @return Returns the unacceptableRemarks.
	 */
	public String getUnacceptableRemarks() {
		return unacceptableRemarks;
	}

	/**
	 * @param unacceptableRemarks The unacceptableRemarks to set.
	 */
	public void setUnacceptableRemarks(String unacceptableRemarks) {
		this.unacceptableRemarks = unacceptableRemarks;
	}

	/**
	 * @return Returns the updatedDate.
	 */
	public ImpreciseDate getUpdatedDate() {
		return updatedDate;
	}

	/**
	 * @param updatedDate The updatedDate to set.
	 */
	public void setUpdatedDate(ImpreciseDate updatedDate) {
		this.updatedDate = updatedDate;
	}

	/**
	 * @return Returns the updateUser.
	 */
	public String getUpdateUser() {
		return updateUser;
	}

	/**
	 * @param updateUser The updateUser to set.
	 */
	public void setUpdateUser(String updateUser) {
		this.updateUser = updateUser;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.parser.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow)
	 */
	public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
		int i=1; // ignore first element (data type)
		SSN = parsedRow.getString(i++);
		legalName.setFamilyName(parsedRow.getString(i++));
		legalName.setGivenName(parsedRow.getString(i++));
		legalName.setMiddleName(parsedRow.getString(i++));
		legalName.setPrefix(parsedRow.getString(i++));
		degree = parsedRow.getString(i++);
		legalName.setSuffix(parsedRow.getString(i++));		
		RawFileDataContainerUtils.setConvertedField(this, "status", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "statusUpdateDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "rejectedRemarks", parsedRow.getString(i++));
		updateUser = parsedRow.getString(i++);
		RawFileDataContainerUtils.setConvertedField(this, "updatedDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "documentType", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "dataSource", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "site", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "docReceivedDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "docLoggedInDate", parsedRow.getString(i++));
		documentAcceptable = parsedRow.getString(i++);
		unacceptableRemarks = parsedRow.getString(i++);
		indicator = parsedRow.getString(i++);
		contactRepAssigned = parsedRow.getString(i++);
	}

	/**
	 * @return Returns the dataSource.
	 */
	public PHDataSource getDataSource() {
		return dataSource;
	}

	/**
	 * @param dataSource The dataSource to set.
	 */
	public void setDataSource(PHDataSource dataSource) {
		this.dataSource = dataSource;
	}

	/**
	 * @return Returns the documentType.
	 */
	public PHDocumentType getDocumentType() {
		return documentType;
	}

	/**
	 * @param documentType The documentType to set.
	 */
	public void setDocumentType(PHDocumentType documentType) {
		this.documentType = documentType;
	}

	/**
	 * @return Returns the sSN.
	 */
	public String getSSN() {
		return SSN;
	}

	/**
	 * @param ssn The sSN to set.
	 */
	public void setSSN(String ssn) {
		SSN = ssn;
	}

	/**
	 * @return Returns the rejectedRemarks.
	 */
	public RejectionRemark getRejectedRemarks() {
		return rejectedRemarks;
	}

	/**
	 * @param rejectedRemarks The rejectedRemarks to set.
	 */
	public void setRejectedRemarks(RejectionRemark rejectedRemarks) {
		this.rejectedRemarks = rejectedRemarks;
	}

	/**
	 * @return Returns the status.
	 */
	public DecorationStatus getStatus() {
		return status;
	}

	/**
	 * @param status The status to set.
	 */
	public void setStatus(DecorationStatus status) {
		this.status = status;
	}

	/**
	 * @return Returns the site.
	 */
	public VAFacility getSite() {
		return site;
	}

	/**
	 * @param site The site to set.
	 */
	public void setSite(VAFacility site) {
		this.site = site;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
	 */
	public OrderedMap getRawFileData() throws Exception {
		OrderedMap map = new ListOrderedMap();
		map.put("header", HECLegacyDataSynchronizationConstants.DataTypes.PURPLE_HEART_DATA_TYPE);
		map.put("SSN", this.SSN);
		map.put("lastName", this.legalName.getFamilyName());
		map.put("firstName", this.legalName.getGivenName());
		map.put("middleName", this.legalName.getMiddleName());
		map.put("prefix", this.legalName.getPrefix());
		map.put("degree", this.degree);
		map.put("suffix", this.getLegalName().getSuffix());
		map.put("status", this.status);
		map.put("statusUpdateDate", this.statusUpdateDate);
		map.put("rejectedRemarks", this.rejectedRemarks);
		map.put("updateUser", this.updateUser);
		map.put("updatedDate", this.updatedDate);
		map.put("documentType", this.documentType);
		map.put("dataSource", this.dataSource);
		map.put("site", this.site);
		map.put("docReceivedDate", this.docReceivedDate);
		map.put("docLoggedInDate", this.docLoggedInDate);
		map.put("documentAcceptable", this.documentAcceptable);
		map.put("unacceptableRemarks", this.unacceptableRemarks);
		map.put("indicator", this.indicator);
		map.put("contactRepAssigned", this.contactRepAssigned);

		return map;
	}

	/**
	 * @return Returns the degree.
	 */
	public String getDegree() {
		return degree;
	}

	/**
	 * @param degree The degree to set.
	 */
	public void setDegree(String degree) {
		this.degree = degree;
	}

}
