/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess.datasync;

import java.util.HashSet;
import java.util.Set;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.POWCampLocation;
import gov.va.med.esr.common.model.lookup.POWDataSource;
import gov.va.med.esr.common.model.lookup.PrisonerOfWarLocation;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;

/**
 * Initial javadoc for class HECLegacyPOWFileData.
 * TODO - Add content here
 * 
 * Created Mar 14, 2006 10:16:31 PM
 * @author DNS   BOHMEG
 */
public class HECLegacyPOWFileData extends AbstractRawFileDataContainer {
	/**
	 * 
	 */
	private static final long serialVersionUID = -1113521275439594788L;
	private String nameforIndex;
	private Name legalName = new Name();
	private String SSN;
	private String confirmed;
	private ImpreciseDate captureDate;
	private ImpreciseDate releaseDate;
	private PrisonerOfWarLocation confinementLocation;
	private POWCampLocation casualtyPlace;
	private POWDataSource source;
	private ImpreciseDate entered;
	private String user;
	private Integer daysIncarcirated;
	private Set serviceNumbers = new HashSet();
	
	static {
		RawFileDataContainerUtils.autoRegisterConvertersForClass();
	}
	
	/**
	 * @return Returns the legalName.
	 */
	public Name getLegalName() {
		return legalName;
	}

	/**
	 * @param legalName The legalName to set.
	 */
	public void setLegalName(Name legalName) {
		this.legalName = legalName;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		// TODO Auto-generated method stub

	}

	/**
	 * @return Returns the captureDate.
	 */
	public ImpreciseDate getCaptureDate() {
		return captureDate;
	}

	/**
	 * @param captureDate The captureDate to set.
	 */
	public void setCaptureDate(ImpreciseDate captureDate) {
		this.captureDate = captureDate;
	}

	/**
	 * @return Returns the confirmed.
	 */
	public String getConfirmed() {
		return confirmed;
	}

	/**
	 * @param confirmed The confirmed to set.
	 */
	public void setConfirmed(String confirmed) {
		this.confirmed = confirmed;
	}

	/**
	 * @return Returns the daysIncarcirated.
	 */
	public Integer getDaysIncarcirated() {
		return daysIncarcirated;
	}

	/**
	 * @param daysIncarcirated The daysIncarcirated to set.
	 */
	public void setDaysIncarcirated(Integer daysIncarcirated) {
		this.daysIncarcirated = daysIncarcirated;
	}

	/**
	 * @return Returns the entered.
	 */
	public ImpreciseDate getEntered() {
		return entered;
	}

	/**
	 * @param entered The entered to set.
	 */
	public void setEntered(ImpreciseDate entered) {
		this.entered = entered;
	}

	/**
	 * @return Returns the releaseDate.
	 */
	public ImpreciseDate getReleaseDate() {
		return releaseDate;
	}

	/**
	 * @param releaseDate The releaseDate to set.
	 */
	public void setReleaseDate(ImpreciseDate releaseDate) {
		this.releaseDate = releaseDate;
	}

	/**
	 * @return Returns the sSN.
	 */
	public String getSSN() {
		return SSN;
	}

	/**
	 * @param ssn The sSN to set.
	 */
	public void setSSN(String ssn) {
		SSN = ssn;
	}

	/**
	 * @return Returns the user.
	 */
	public String getUser() {
		return user;
	}

	/**
	 * @param user The user to set.
	 */
	public void setUser(String user) {
		this.user = user;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.parser.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow)
	 */
	public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
		int i=1; // ignore first element (data type)
		i++; // ignore first incoming field for nameForIndex (ESR doesn't use this)
		legalName.setFamilyName(parsedRow.getString(i++));
		legalName.setGivenName(parsedRow.getString(i++));
		legalName.setMiddleName(parsedRow.getString(i++));
		legalName.setSuffix(parsedRow.getString(i++));
		SSN = parsedRow.getString(i++);
		confirmed = parsedRow.getString(i++);
		RawFileDataContainerUtils.setConvertedField(this, "captureDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "releaseDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "confinementLocation", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "casualtyPlace", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "source", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "entered", parsedRow.getString(i++));
		user = parsedRow.getString(i++);
		RawFileDataContainerUtils.setConvertedField(this, "daysIncarcirated", parsedRow.getString(i++));
		
		serviceNumbers = new HashSet(RawFileDataContainerUtils.parseMultipleValues(parsedRow.getString(i++),
				HECLegacyDataSynchronizationConstants.Delimiters.SECONDARY));		
	}
		
	/**
	 * @return Returns the confinementLocation.
	 */
	public PrisonerOfWarLocation getConfinementLocation() {
		return confinementLocation;
	}

	/**
	 * @param confinementLocation The confinementLocation to set.
	 */
	public void setConfinementLocation(PrisonerOfWarLocation confinementLocation) {
		this.confinementLocation = confinementLocation;
	}

	/**
	 * @return Returns the nameforIndex.
	 */
	public String getNameforIndex() {
		StringBuffer buf = new StringBuffer();
		if(StringUtils.isNotBlank(legalName.getFamilyName()))
			buf.append(legalName.getFamilyName());
		if(StringUtils.isNotBlank(legalName.getSuffix()))
			buf.append(" ").append(legalName.getSuffix());
		if(StringUtils.isNotBlank(legalName.getGivenName()))
			buf.append(",").append(legalName.getGivenName());
		if(StringUtils.isNotBlank(legalName.getMiddleName()))
			buf.append(" ").append(legalName.getMiddleName());
		return buf.toString();
	}

	/**
	 * @return Returns the casualtyPlace.
	 */
	public POWCampLocation getCasualtyPlace() {
		return casualtyPlace;
	}

	/**
	 * @param casualtyPlace The casualtyPlace to set.
	 */
	public void setCasualtyPlace(POWCampLocation casualtyPlace) {
		this.casualtyPlace = casualtyPlace;
	}

	/**
	 * @return Returns the source.
	 */
	public POWDataSource getSource() {
		return source;
	}

	/**
	 * @param source The source to set.
	 */
	public void setSource(POWDataSource source) {
		this.source = source;
	}

	/**
	 * @return Returns the serviceNumbers.
	 */
	public Set getServiceNumbers() {
		return serviceNumbers;
	}

	/**
	 * @param serviceNumbers The serviceNumbers to set.
	 */
	public void setServiceNumbers(Set serviceNumbers) {
		this.serviceNumbers = serviceNumbers;
	}

	public void addServiceNumber(String serviceNumber) {
		serviceNumbers.add(serviceNumber);
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
	 */
	public OrderedMap getRawFileData() throws Exception {
		OrderedMap map = new ListOrderedMap();
		map.put("header", HECLegacyDataSynchronizationConstants.DataTypes.POW_DATA_TYPE);
		map.put("nameforIndex", getNameforIndex());
		map.put("lastName", this.legalName.getFamilyName());
		map.put("firstName", this.legalName.getGivenName());
		map.put("middleName", this.legalName.getMiddleName());
		map.put("suffix", this.legalName.getSuffix());
		map.put("SSN", this.SSN);
		map.put("confirmed", this.confirmed);
		map.put("captureDate", this.captureDate);
		map.put("releaseDate", this.releaseDate);
		map.put("confinementLocation", this.confinementLocation);
		map.put("casualtyPlace", this.casualtyPlace);
		map.put("source", this.source);
		map.put("entered", this.entered);
		map.put("user", this.user);
		map.put("daysIncarcirated", this.daysIncarcirated);
		map.put("serviceNumbers", RawFileDataContainerUtils.formatMultipleValues(serviceNumbers, 
				HECLegacyDataSynchronizationConstants.Delimiters.SECONDARY));
		return map;
	}

}
