/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess.datasync;

import org.apache.commons.lang.StringUtils;

import gov.va.med.fw.io.FieldTransformer;
import gov.va.med.fw.service.AbstractComponent;

import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;

/**
 * Initial javadoc for class HECLegacyLetterFormFieldTransformer.
 * TODO - Add content here
 * 
 * Created Jun 9, 2006 3:10:25 PM
 * @author DNS   BOHMEG
 */
public class HECLegacyLetterFormFieldTransformer extends AbstractComponent
		implements FieldTransformer {

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.FieldTransformer#transformData(java.lang.String, java.lang.Object)
	 */
	public Object transformData(String fieldName, Object data) throws Exception {
		String letterNumber = data != null ? data.toString() : null;
		if(StringUtils.isNotBlank(letterNumber)) {
			int index = letterNumber.indexOf(ComLetterTemplateType.FORM_NUMBER_PREFIX) +
				ComLetterTemplateType.FORM_NUMBER_PREFIX.length();
			letterNumber = letterNumber.substring(index, letterNumber.length());
		}
		return letterNumber;
	}

}
