/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess.datasync;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;

/**
 * Initial javadoc for class HECLegacyIdentityFileData.
 * TODO - Add content here
 * 
 * Created Mar 14, 2006 10:14:09 PM
 * @author DNS   BOHMEG
 */
public class HECLegacyIdentityFileData extends AbstractRawFileDataContainer {
	/**
	 * 
	 */
	private static final long serialVersionUID = 2688025902885572269L;
	private String ICN;
	private String SSN;
	private Name legalName = new Name();
	private String degree;
	private ImpreciseDate dateOfBirth;
	private Gender gender;
	private RegistryType registryType;
	private String commsFlag;
	
	static {
		RawFileDataContainerUtils.autoRegisterConvertersForClass();
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.parser.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow)
	 */
	public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
		int i=1; // ignore first element (data type)
		ICN = parsedRow.getString(i++);
		SSN = parsedRow.getString(i++);
		
		int nameDataIndex = 0;
		List nameData = RawFileDataContainerUtils.parseMultipleValues(parsedRow.getString(i++), HECLegacyDataSynchronizationConstants.Delimiters.TERTIARY);
		if(nameData.size() > nameDataIndex)
			legalName.setFamilyName((String) nameData.get(nameDataIndex++));
		if(nameData.size() > nameDataIndex)
			legalName.setGivenName((String)nameData.get(nameDataIndex++));
		if(nameData.size() > nameDataIndex)		
			legalName.setMiddleName((String) nameData.get(nameDataIndex++));
		if(nameData.size() > nameDataIndex)		
			legalName.setSuffix((String) nameData.get(nameDataIndex++));
		if(nameData.size() > nameDataIndex)		
			legalName.setPrefix((String) nameData.get(nameDataIndex++));
		if(nameData.size() > nameDataIndex)		
			degree = (String) nameData.get(nameDataIndex++);
		
		RawFileDataContainerUtils.setConvertedField(this, "dateOfBirth", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "gender", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "registryType", parsedRow.getString(i++));
		commsFlag = parsedRow.getString(i++);
	}	

	/* (non-Javadoc)
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		builder.append("ICN", ICN).//.append("SSN", SSN)
		append("legalName", legalName).
		append("dateOfBirth", dateOfBirth).append("gender", gender).append("registryType", registryType);
	}


	/**
	 * @return Returns the legalName.
	 */
	public Name getLegalName() {
		return legalName;
	}

	/**
	 * @param legalName The legalName to set.
	 */
	public void setLegalName(Name legalName) {
		this.legalName = legalName;
	}

	/**
	 * @return Returns the gender.
	 */
	public Gender getGender() {
		return gender;
	}

	/**
	 * @param gender The gender to set.
	 */
	public void setGender(Gender gender) {
		this.gender = gender;
	}

	/**
	 * @return Returns the iCN.
	 */
	public String getICN() {
		return ICN;
	}

	/**
	 * @param icn The iCN to set.
	 */
	public void setICN(String icn) {
		ICN = icn;
	}

	public boolean isPersonUpdate() {
		return StringUtils.isNotBlank(ICN);
	}

	/**
	 * @return Returns the sSN.
	 */
	public String getSSN() {
		return SSN;
	}

	/**
	 * @param ssn The sSN to set.
	 */
	public void setSSN(String ssn) {
		SSN = ssn;
	}


	/**
	 * @return Returns the dateOfBirth.
	 */
	public ImpreciseDate getDateOfBirth() {
		return dateOfBirth;
	}


	/**
	 * @param dateOfBirth The dateOfBirth to set.
	 */
	public void setDateOfBirth(ImpreciseDate dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}

	/**
	 * @return Returns the registryType.
	 */
	public RegistryType getRegistryType() {
		return registryType;
	}

	/**
	 * @param registryType The registryType to set.
	 */
	public void setRegistryType(RegistryType registryType) {
		this.registryType = registryType;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
	 */
	public OrderedMap getRawFileData() throws Exception {
		OrderedMap map = new ListOrderedMap();
		map.put("header", HECLegacyDataSynchronizationConstants.DataTypes.IDENTITY_DATA_TYPE);
		map.put("ICN", ICN);
		map.put("SSN", SSN);
		
		List nameData = new ArrayList();
		nameData.add(legalName != null ? StringUtils.trimToEmpty(legalName.getFamilyName()) : StringUtils.EMPTY);
		nameData.add(legalName != null ? StringUtils.trimToEmpty(legalName.getGivenName()) : StringUtils.EMPTY);
		nameData.add(legalName != null ? StringUtils.trimToEmpty(legalName.getMiddleName()) : StringUtils.EMPTY);
		nameData.add(legalName != null ? StringUtils.trimToEmpty(legalName.getSuffix()) : StringUtils.EMPTY);
		nameData.add(legalName != null ? StringUtils.trimToEmpty(legalName.getPrefix()) : StringUtils.EMPTY);
		nameData.add(StringUtils.isNotBlank(degree) ? degree : StringUtils.EMPTY);
		map.put("name", RawFileDataContainerUtils.formatMultipleValues(nameData, HECLegacyDataSynchronizationConstants.Delimiters.TERTIARY));
		
		map.put("dateOfBirth", dateOfBirth);
		map.put("gender", gender);
		map.put("registryType", registryType);
		map.put("commsFlag", commsFlag);
		return map;
	}

	/**
	 * @return Returns the degree.
	 */
	public String getDegree() {
		return degree;
	}

	/**
	 * @param degree The degree to set.
	 */
	public void setDegree(String degree) {
		this.degree = degree;
	}

	public String isCommsFlag() {
		return commsFlag;
	}

	public void setCommsFlag(String commsFlag) {
		this.commsFlag = commsFlag;
	}
	
	public boolean isCommsOnly() {
		return (commsFlag != null && commsFlag.equals("1"));
	}
}
