/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess.datasync;

import java.math.BigDecimal;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Name;

/**
 * Initial javadoc for class HECLegacyFinancialFileData.
 * TODO - Add content here
 * 
 * Created Mar 14, 2006 10:16:12 PM
 * @author DNS   BOHMEG
 */
public class HECLegacyFinancialFileData extends AbstractRawFileDataContainer {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1528659954004058903L;
	private Integer incomeYear;
	private HECLegacyFinancialAmountsFileData financialAmounts = new HECLegacyFinancialAmountsFileData();
	private String marriedLastCalendarYear;
	private BigDecimal amountContributedToSpouse;
	private Integer numberOfDependentChildren;
	private ImpreciseDate meansTestDate;
	private MeansTestStatus meansTestStatus;
	private BigDecimal totalIncome;
	private BigDecimal netWorth;
	private ImpreciseDate meansTestAdjudicationDate;
	private String agreedToPayDeductible;
	private BigDecimal thresholdA;
	private ImpreciseDate meansTestCompletedDate;
	private Integer totalDependents;
	private String declinesToGiveIncomeInfo;
	private ImpreciseDate copayTestDate;
	private MeansTestStatus copayTestStatus;
	private ImpreciseDate copayTestCompletedDate;
	private String ranchFarmOwner;
	private ImpreciseDate copayTestAdjudicationDate;
	private VAFacility siteConductingMeansTest;
	private ImpreciseDate testLastEditedDate;
	private MeansTestStatus meansTestDeterminedStatus;
	private MeansTestStatus copayTestDeterminedStatus;
	private BigDecimal GMTThreshold;
	private Address GMTAddress = new Address();
	private AssociationType guardianType;
	private Name guardianName = new Name();
	private String guardianInstitution;
	private Address guardianAddress = new Address();
	private String guardianPhone;
	private String guardianRelationship;
	private ImpreciseDate incompetentVARulingDate;
	private ImpreciseDate incompetentCivilRulingDate;
	private IncomeTestSource sourceOfPrimaryIncomeTest;
	
	static {
		RawFileDataContainerUtils.autoRegisterConvertersForClass();
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		// TODO Auto-generated method stub

	}

	/**
	 * @return Returns the incomeYear.
	 */
	public Integer getIncomeYear() {
		return incomeYear;
	}

	/**
	 * @param incomeYear The incomeYear to set.
	 */
	public void setIncomeYear(Integer incomeYear) {
		this.incomeYear = incomeYear;
	}

	/**
	 * @return Returns the agreedToPayDeductible.
	 */
	public String getAgreedToPayDeductible() {
		return agreedToPayDeductible;
	}

	/**
	 * @param agreedToPayDeductible The agreedToPayDeductible to set.
	 */
	public void setAgreedToPayDeductible(String agreedToPayDeductible) {
		this.agreedToPayDeductible = agreedToPayDeductible;
	}

	/**
	 * @return Returns the copayTestCompletedDate.
	 */
	public ImpreciseDate getCopayTestCompletedDate() {
		return copayTestCompletedDate;
	}

	/**
	 * @param copayTestCompletedDate The copayTestCompletedDate to set.
	 */
	public void setCopayTestCompletedDate(ImpreciseDate copayTestCompletedDate) {
		this.copayTestCompletedDate = copayTestCompletedDate;
	}

	/**
	 * @return Returns the copayTestDate.
	 */
	public ImpreciseDate getCopayTestDate() {
		return copayTestDate;
	}

	/**
	 * @param copayTestDate The copayTestDate to set.
	 */
	public void setCopayTestDate(ImpreciseDate copayTestDate) {
		this.copayTestDate = copayTestDate;
	}

	/**
	 * @return Returns the declinesToGiveIncomeInfo.
	 */
	public String getDeclinesToGiveIncomeInfo() {
		return declinesToGiveIncomeInfo;
	}

	/**
	 * @param declinesToGiveIncomeInfo The declinesToGiveIncomeInfo to set.
	 */
	public void setDeclinesToGiveIncomeInfo(String declinesToGiveIncomeInfo) {
		this.declinesToGiveIncomeInfo = declinesToGiveIncomeInfo;
	}

	/**
	 * @return Returns the gMTAddress.
	 */
	public Address getGMTAddress() {
		return GMTAddress;
	}

	/**
	 * @param address The gMTAddress to set.
	 */
	public void setGMTAddress(Address address) {
		GMTAddress = address;
	}

	/**
	 * @return Returns the guardianAddress.
	 */
	public Address getGuardianAddress() {
		return guardianAddress;
	}

	/**
	 * @param guardianAddress The guardianAddress to set.
	 */
	public void setGuardianAddress(Address guardianAddress) {
		this.guardianAddress = guardianAddress;
	}

	/**
	 * @return Returns the guardianInstitution.
	 */
	public String getGuardianInstitution() {
		return guardianInstitution;
	}

	/**
	 * @param guardianInstitution The guardianInstitution to set.
	 */
	public void setGuardianInstitution(String guardianInstitution) {
		this.guardianInstitution = guardianInstitution;
	}

	/**
	 * @return Returns the guardianPhone.
	 */
	public String getGuardianPhone() {
		return guardianPhone;
	}

	/**
	 * @param guardianPhone The guardianPhone to set.
	 */
	public void setGuardianPhone(String guardianPhone) {
		this.guardianPhone = guardianPhone;
	}

	/**
	 * @return Returns the guardianRelationship.
	 */
	public String getGuardianRelationship() {
		return guardianRelationship;
	}

	/**
	 * @param guardianRelationship The guardianRelationship to set.
	 */
	public void setGuardianRelationship(String guardianRelationship) {
		this.guardianRelationship = guardianRelationship;
	}

	/**
	 * @return Returns the incompetentCivilRulingDate.
	 */
	public ImpreciseDate getIncompetentCivilRulingDate() {
		return incompetentCivilRulingDate;
	}

	/**
	 * @param incompetentCivilRulingDate The incompetentCivilRulingDate to set.
	 */
	public void setIncompetentCivilRulingDate(
			ImpreciseDate incompetentCivilRulingDate) {
		this.incompetentCivilRulingDate = incompetentCivilRulingDate;
	}

	/**
	 * @return Returns the incompetentVARulingDate.
	 */
	public ImpreciseDate getIncompetentVARulingDate() {
		return incompetentVARulingDate;
	}

	/**
	 * @param incompetentVARulingDate The incompetentVARulingDate to set.
	 */
	public void setIncompetentVARulingDate(ImpreciseDate incompetentVARulingDate) {
		this.incompetentVARulingDate = incompetentVARulingDate;
	}

	/**
	 * @return Returns the marriedLastCalendarYear.
	 */
	public String getMarriedLastCalendarYear() {
		return marriedLastCalendarYear;
	}

	/**
	 * @param marriedLastCalendarYear The marriedLastCalendarYear to set.
	 */
	public void setMarriedLastCalendarYear(String marriedLastCalendarYear) {
		this.marriedLastCalendarYear = marriedLastCalendarYear;
	}

	/**
	 * @return Returns the meansTestCompletedDate.
	 */
	public ImpreciseDate getMeansTestCompletedDate() {
		return meansTestCompletedDate;
	}

	/**
	 * @param meansTestCompletedDate The meansTestCompletedDate to set.
	 */
	public void setMeansTestCompletedDate(ImpreciseDate meansTestCompletedDate) {
		this.meansTestCompletedDate = meansTestCompletedDate;
	}

	/**
	 * @return Returns the meansTestDate.
	 */
	public ImpreciseDate getMeansTestDate() {
		return meansTestDate;
	}

	/**
	 * @param meansTestDate The meansTestDate to set.
	 */
	public void setMeansTestDate(ImpreciseDate meansTestDate) {
		this.meansTestDate = meansTestDate;
	}

	/**
	 * @return Returns the meansTestStatus.
	 */
	public MeansTestStatus getMeansTestStatus() {
		return meansTestStatus;
	}

	/**
	 * @param meansTestStatus The meansTestStatus to set.
	 */
	public void setMeansTestStatus(MeansTestStatus meansTestStatus) {
		this.meansTestStatus = meansTestStatus;
	}

	/**
	 * @return Returns the netWorth.
	 */
	public BigDecimal getNetWorth() {
		return netWorth;
	}

	/**
	 * @param netWorth The netWorth to set.
	 */
	public void setNetWorth(BigDecimal netWorth) {
		this.netWorth = netWorth;
	}

	/**
	 * @return Returns the numberOfDependentChildren.
	 */
	public Integer getNumberOfDependentChildren() {
		return numberOfDependentChildren;
	}

	/**
	 * @param numberOfDependentChildren The numberOfDependentChildren to set.
	 */
	public void setNumberOfDependentChildren(Integer numberOfDependentChildren) {
		this.numberOfDependentChildren = numberOfDependentChildren;
	}

	/**
	 * @return Returns the ranchFarmOwner.
	 */
	public String getRanchFarmOwner() {
		return ranchFarmOwner;
	}

	/**
	 * @param ranchFarmOwner The ranchFarmOwner to set.
	 */
	public void setRanchFarmOwner(String ranchFarmOwner) {
		this.ranchFarmOwner = ranchFarmOwner;
	}

	/**
	 * @return Returns the testLastEditedDate.
	 */
	public ImpreciseDate getTestLastEditedDate() {
		return testLastEditedDate;
	}

	/**
	 * @param testLastEditedDate The testLastEditedDate to set.
	 */
	public void setTestLastEditedDate(ImpreciseDate testLastEditedDate) {
		this.testLastEditedDate = testLastEditedDate;
	}

	/**
	 * @return Returns the totalDependents.
	 */
	public Integer getTotalDependents() {
		return totalDependents;
	}

	/**
	 * @param totalDependents The totalDependents to set.
	 */
	public void setTotalDependents(Integer totalDependents) {
		this.totalDependents = totalDependents;
	}

	/**
	 * @return Returns the totalIncome.
	 */
	public BigDecimal getTotalIncome() {
		return totalIncome;
	}

	/**
	 * @param totalIncome The totalIncome to set.
	 */
	public void setTotalIncome(BigDecimal totalIncome) {
		this.totalIncome = totalIncome;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.parser.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow)
	 */
	public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
		int i=1; // ignore first element (data type)
		RawFileDataContainerUtils.setConvertedField(this, "incomeYear", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "socialSecurityNotSSIAmount", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "USCivilService", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "USRailroadRetirement", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "militaryRetirement", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "unemploymentCompensation", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "otherRetirement", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "totalIncomeFromEmployment", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "interestDividendAnnuity", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "workersCompBlackLung", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "allOtherIncome", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "medicalExpenses", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "funeralAndBurialExpenses", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "educationExpenses", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "cashInBank", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "stocksAndBonds", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "realProperty", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "otherPropertyAndAssets", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "debts", parsedRow.getString(i++));		
		marriedLastCalendarYear = parsedRow.getString(i++);
		RawFileDataContainerUtils.setConvertedField(this, "amountContributedToSpouse", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "numberOfDependentChildren", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "meansTestDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "meansTestStatus", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "totalIncome", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "netWorth", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "meansTestAdjudicationDate", parsedRow.getString(i++));
		agreedToPayDeductible = parsedRow.getString(i++);
		RawFileDataContainerUtils.setConvertedField(this, "thresholdA", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "meansTestCompletedDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "totalDependents", parsedRow.getString(i++));
		declinesToGiveIncomeInfo = parsedRow.getString(i++);
		RawFileDataContainerUtils.setConvertedField(this, "copayTestDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "copayTestStatus", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "copayTestCompletedDate", parsedRow.getString(i++));
		ranchFarmOwner = parsedRow.getString(i++);
		RawFileDataContainerUtils.setConvertedField(this, "copayTestAdjudicationDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "siteConductingMeansTest", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "testLastEditedDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "meansTestDeterminedStatus", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "copayTestDeterminedStatus", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "GMTThreshold", parsedRow.getString(i++));
		GMTAddress.setLine1(parsedRow.getString(i++));
		GMTAddress.setLine2(parsedRow.getString(i++));
		GMTAddress.setCity(parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(GMTAddress, "state", parsedRow.getString(i++));
		GMTAddress.setZipCode(parsedRow.getString(i++));
		GMTAddress.setCounty(parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "guardianType", parsedRow.getString(i++));
		guardianName.setFamilyName(parsedRow.getString(i++));
		guardianInstitution = parsedRow.getString(i++);
		guardianAddress.setLine1(parsedRow.getString(i++));
		guardianAddress.setLine2(parsedRow.getString(i++));
		guardianAddress.setCity(parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(guardianAddress, "state", parsedRow.getString(i++));
		guardianAddress.setZipCode(parsedRow.getString(i++));
		guardianPhone = parsedRow.getString(i++);
		guardianRelationship = parsedRow.getString(i++);
		RawFileDataContainerUtils.setConvertedField(this, "incompetentVARulingDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "incompetentCivilRulingDate", parsedRow.getString(i++));		
		RawFileDataContainerUtils.setConvertedField(this, "sourceOfPrimaryIncomeTest", parsedRow.getString(i++));
	}

	/**
	 * @return Returns the copayTestDeterminedStatus.
	 */
	public MeansTestStatus getCopayTestDeterminedStatus() {
		return copayTestDeterminedStatus;
	}

	/**
	 * @param copayTestDeterminedStatus The copayTestDeterminedStatus to set.
	 */
	public void setCopayTestDeterminedStatus(
			MeansTestStatus copayTestDeterminedStatus) {
		this.copayTestDeterminedStatus = copayTestDeterminedStatus;
	}

	/**
	 * @return Returns the copayTestStatus.
	 */
	public MeansTestStatus getCopayTestStatus() {
		return copayTestStatus;
	}

	/**
	 * @param copayTestStatus The copayTestStatus to set.
	 */
	public void setCopayTestStatus(MeansTestStatus copayTestStatus) {
		this.copayTestStatus = copayTestStatus;
	}

	/**
	 * @return Returns the meansTestDeterminedStatus.
	 */
	public MeansTestStatus getMeansTestDeterminedStatus() {
		return meansTestDeterminedStatus;
	}

	/**
	 * @param meansTestDeterminedStatus The meansTestDeterminedStatus to set.
	 */
	public void setMeansTestDeterminedStatus(
			MeansTestStatus meansTestDeterminedStatus) {
		this.meansTestDeterminedStatus = meansTestDeterminedStatus;
	}

	/**
	 * @return Returns the copayTestAdjudicationDate.
	 */
	public ImpreciseDate getCopayTestAdjudicationDate() {
		return copayTestAdjudicationDate;
	}

	/**
	 * @param copayTestAdjudicationDate The copayTestAdjudicationDate to set.
	 */
	public void setCopayTestAdjudicationDate(ImpreciseDate copayTestAdjudicationDate) {
		this.copayTestAdjudicationDate = copayTestAdjudicationDate;
	}

	/**
	 * @return Returns the meansTestAdjudicationDate.
	 */
	public ImpreciseDate getMeansTestAdjudicationDate() {
		return meansTestAdjudicationDate;
	}

	/**
	 * @param meansTestAdjudicationDate The meansTestAdjudicationDate to set.
	 */
	public void setMeansTestAdjudicationDate(ImpreciseDate meansTestAdjudicationDate) {
		this.meansTestAdjudicationDate = meansTestAdjudicationDate;
	}

	/**
	 * @return Returns the thresholdA.
	 */
	public BigDecimal getThresholdA() {
		return thresholdA;
	}

	/**
	 * @param thresholdA The thresholdA to set.
	 */
	public void setThresholdA(BigDecimal thresholdA) {
		this.thresholdA = thresholdA;
	}

	/**
	 * @return Returns the siteConductingMeansTest.
	 */
	public VAFacility getSiteConductingMeansTest() {
		return siteConductingMeansTest;
	}

	/**
	 * @param siteConductingMeansTest The siteConductingMeansTest to set.
	 */
	public void setSiteConductingMeansTest(VAFacility siteConductingMeansTest) {
		this.siteConductingMeansTest = siteConductingMeansTest;
	}

	/**
	 * @return Returns the gMTThreshold.
	 */
	public BigDecimal getGMTThreshold() {
		return GMTThreshold;
	}

	/**
	 * @param threshold The gMTThreshold to set.
	 */
	public void setGMTThreshold(BigDecimal threshold) {
		GMTThreshold = threshold;
	}

	/**
	 * @return Returns the guardianType.
	 */
	public AssociationType getGuardianType() {
		return guardianType;
	}

	/**
	 * @param guardianType The guardianType to set.
	 */
	public void setGuardianType(AssociationType guardianType) {
		this.guardianType = guardianType;
	}

	/**
	 * @return Returns the guardianName.
	 */
	public Name getGuardianName() {
		return guardianName;
	}

	/**
	 * @param guardianName The guardianName to set.
	 */
	public void setGuardianName(Name guardianName) {
		this.guardianName = guardianName;
	}

	/**
	 * @return Returns the amountContributedToSpouse.
	 */
	public BigDecimal getAmountContributedToSpouse() {
		return amountContributedToSpouse;
	}

	/**
	 * @param amountContributedToSpouse The amountContributedToSpouse to set.
	 */
	public void setAmountContributedToSpouse(BigDecimal amountContributedToSpouse) {
		this.amountContributedToSpouse = amountContributedToSpouse;
	}

	/**
	 * @return Returns the financialAmounts.
	 */
	public HECLegacyFinancialAmountsFileData getFinancialAmounts() {
		return financialAmounts;
	}

	/**
	 * @param financialAmounts The financialAmounts to set.
	 */
	public void setFinancialAmounts(
			HECLegacyFinancialAmountsFileData financialAmounts) {
		this.financialAmounts = financialAmounts;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
	 */
	public OrderedMap getRawFileData() throws Exception {
		OrderedMap map = new ListOrderedMap();
		map.put("header", HECLegacyDataSynchronizationConstants.DataTypes.FINANCIAL_DATA_TYPE);
		map.put("incomeYear", this.incomeYear);
		financialAmounts.addRawFileData(map);
		map.put("marriedLastCalendarYear", this.marriedLastCalendarYear);
		map.put("amountContributedToSpouse", this.amountContributedToSpouse);	
		map.put("numberOfDependentChildren", this.numberOfDependentChildren);
		map.put("meansTestDate", this.meansTestDate);
		map.put("meansTestStatus", this.meansTestStatus);
		map.put("totalIncome", this.totalIncome);
		map.put("netWorth", this.netWorth);
		map.put("meansTestAdjudicationDate", this.meansTestAdjudicationDate);
		map.put("agreedToPayDeductible", this.agreedToPayDeductible);
		map.put("thresholdA", this.thresholdA);
		map.put("meansTestCompletedDate", this.meansTestCompletedDate);
		map.put("totalDependents", this.totalDependents);
		map.put("declinesToGiveIncomeInfo", this.declinesToGiveIncomeInfo);
		map.put("copayTestDate", this.copayTestDate);
		map.put("copayTestStatus", this.copayTestStatus);
		map.put("copayTestCompletedDate", this.copayTestCompletedDate);
		map.put("ranchFarmOwner", this.ranchFarmOwner);
		map.put("copayTestAdjudicationDate", this.copayTestAdjudicationDate);
		map.put("siteConductingMeansTest", this.siteConductingMeansTest);		
		map.put("testLastEditedDate", this.testLastEditedDate);
		map.put("meansTestDeterminedStatus", this.meansTestDeterminedStatus);
		map.put("copayTestDeterminedStatus", this.copayTestDeterminedStatus);
		map.put("GMTThreshold", this.GMTThreshold);
		map.put("GMTAddressLine1", this.GMTAddress.getLine1());
		if(StringUtils.isNotBlank(GMTAddress.getLine2()) || StringUtils.isNotBlank(GMTAddress.getLine3())) {
			String line2 = GMTAddress.getLine2();
			String line3 = GMTAddress.getLine3();
			map.put("GMTAddressLine2", (StringUtils.isNotBlank(line2) ? line2 : StringUtils.EMPTY) + " " + 
					(StringUtils.isNotBlank(line3) ? line3 : StringUtils.EMPTY));
		}
		else
			map.put("GMTAddressLine2", StringUtils.EMPTY);
		map.put("GMTAddressCity", this.GMTAddress.getCity());
		map.put("GMTAddressState", this.GMTAddress.getState());
		map.put("GMTAddressZipCode", this.GMTAddress.getZipCode());
		map.put("GMTAddressCounty", this.getGMTAddress());  // transformer needs entire Address to determine County
		map.put("guardianType", this.guardianType);
		if(StringUtils.isNotBlank(guardianName.getGivenName()) || StringUtils.isNotBlank(guardianName.getFamilyName())) {
			String first = guardianName.getGivenName();
			String last = guardianName.getFamilyName();
			map.put("guardianName", (StringUtils.isNotBlank(first) ? first : StringUtils.EMPTY) + " " + 
					(StringUtils.isNotBlank(last) ? last : StringUtils.EMPTY));
		}
		else
			map.put("guardianName", StringUtils.EMPTY);
		map.put("guardianInstitution", this.guardianInstitution);
		map.put("guardianAddressLine1", this.guardianAddress.getLine1());
		if(StringUtils.isNotBlank(guardianAddress.getLine2()) || StringUtils.isNotBlank(guardianAddress.getLine3())) {
			String line2 = guardianAddress.getLine2();
			String line3 = guardianAddress.getLine3();
			map.put("guardianAddressLine2", (StringUtils.isNotBlank(line2) ? line2 : StringUtils.EMPTY) + " " + 
					(StringUtils.isNotBlank(line3) ? line3 : StringUtils.EMPTY));
		}
		else
			map.put("guardianAddressLine2", StringUtils.EMPTY);
		map.put("guardianAddressCity", this.guardianAddress.getCity());
		map.put("guardianAddressState", this.guardianAddress.getState());
		map.put("guardianAddressZipCode", this.guardianAddress.getZipCode());
		map.put("guardianPhone", this.guardianPhone);
		map.put("guardianRelationship", this.guardianRelationship);
		map.put("incompetentVARulingDate", this.incompetentVARulingDate);
		map.put("incompetentCivilRulingDate", this.incompetentCivilRulingDate);
		map.put("sourceOfPrimaryIncomeTest", this.sourceOfPrimaryIncomeTest);
		return map;
	}

	/**
	 * @return Returns the sourceOfPrimaryIncomeTest.
	 */
	public IncomeTestSource getSourceOfPrimaryIncomeTest() {
		return sourceOfPrimaryIncomeTest;
	}

	/**
	 * @param sourceOfPrimaryIncomeTest The sourceOfPrimaryIncomeTest to set.
	 */
	public void setSourceOfPrimaryIncomeTest(
			IncomeTestSource sourceOfPrimaryIncomeTest) {
		this.sourceOfPrimaryIncomeTest = sourceOfPrimaryIncomeTest;
	}
}