/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.batchprocess.datasync;

import java.math.BigDecimal;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractEntity;

/**
 * Initial javadoc for class HECLegacyFinancialAmountsFileData. TODO - Add
 * content here
 * 
 * Created Mar 31, 2006 9:58:23 AM
 * 
 * @author DNS   BOHMEG
 */
public class HECLegacyFinancialAmountsFileData extends AbstractEntity {
	
    private static final long serialVersionUID = 7794602461430979693L;

    private BigDecimal socialSecurityNotSSIAmount;

	private BigDecimal USCivilService;

	private BigDecimal USRailroadRetirement;

	private BigDecimal militaryRetirement;

	private BigDecimal unemploymentCompensation;

	private BigDecimal otherRetirement;

	private BigDecimal totalIncomeFromEmployment;

	private BigDecimal interestDividendAnnuity;

	private BigDecimal workersCompBlackLung;

	private BigDecimal allOtherIncome;

	private BigDecimal medicalExpenses;

	private BigDecimal funeralAndBurialExpenses;

	private BigDecimal educationExpenses;

	private BigDecimal cashInBank;

	private BigDecimal stocksAndBonds;

	private BigDecimal realProperty;

	private BigDecimal otherPropertyAndAssets;

	private BigDecimal debts;

	/**
	 * @return Returns the allOtherIncome.
	 */
	public BigDecimal getAllOtherIncome() {
		return allOtherIncome;
	}

	/**
	 * @param allOtherIncome
	 *            The allOtherIncome to set.
	 */
	public void setAllOtherIncome(BigDecimal allOtherIncome) {
		this.allOtherIncome = allOtherIncome;
	}

	/**
	 * @return Returns the cashInBank.
	 */
	public BigDecimal getCashInBank() {
		return cashInBank;
	}

	/**
	 * @param cashInBank
	 *            The cashInBank to set.
	 */
	public void setCashInBank(BigDecimal cashInBank) {
		this.cashInBank = cashInBank;
	}

	/**
	 * @return Returns the debts.
	 */
	public BigDecimal getDebts() {
		return debts;
	}

	/**
	 * @param debts
	 *            The debts to set.
	 */
	public void setDebts(BigDecimal debts) {
		this.debts = debts;
	}

	/**
	 * @return Returns the educationExpenses.
	 */
	public BigDecimal getEducationExpenses() {
		return educationExpenses;
	}

	/**
	 * @param educationExpenses
	 *            The educationExpenses to set.
	 */
	public void setEducationExpenses(BigDecimal educationExpenses) {
		this.educationExpenses = educationExpenses;
	}

	/**
	 * @return Returns the funeralAndBurialExpenses.
	 */
	public BigDecimal getFuneralAndBurialExpenses() {
		return funeralAndBurialExpenses;
	}

	/**
	 * @param funeralAndBurialExpenses
	 *            The funeralAndBurialExpenses to set.
	 */
	public void setFuneralAndBurialExpenses(BigDecimal funeralAndBurialExpenses) {
		this.funeralAndBurialExpenses = funeralAndBurialExpenses;
	}

	/**
	 * @return Returns the interestDividendAnnuity.
	 */
	public BigDecimal getInterestDividendAnnuity() {
		return interestDividendAnnuity;
	}

	/**
	 * @param interestDividendAnnuity
	 *            The interestDividendAnnuity to set.
	 */
	public void setInterestDividendAnnuity(BigDecimal interestDividendAnnuity) {
		this.interestDividendAnnuity = interestDividendAnnuity;
	}

	/**
	 * @return Returns the medicalExpenses.
	 */
	public BigDecimal getMedicalExpenses() {
		return medicalExpenses;
	}

	/**
	 * @param medicalExpenses
	 *            The medicalExpenses to set.
	 */
	public void setMedicalExpenses(BigDecimal medicalExpenses) {
		this.medicalExpenses = medicalExpenses;
	}

	/**
	 * @return Returns the militaryRetirement.
	 */
	public BigDecimal getMilitaryRetirement() {
		return militaryRetirement;
	}

	/**
	 * @param militaryRetirement
	 *            The militaryRetirement to set.
	 */
	public void setMilitaryRetirement(BigDecimal militaryRetirement) {
		this.militaryRetirement = militaryRetirement;
	}

	/**
	 * @return Returns the otherPropertyAndAssets.
	 */
	public BigDecimal getOtherPropertyAndAssets() {
		return otherPropertyAndAssets;
	}

	/**
	 * @param otherPropertyAndAssets
	 *            The otherPropertyAndAssets to set.
	 */
	public void setOtherPropertyAndAssets(BigDecimal otherPropertyAndAssets) {
		this.otherPropertyAndAssets = otherPropertyAndAssets;
	}

	/**
	 * @return Returns the otherRetirement.
	 */
	public BigDecimal getOtherRetirement() {
		return otherRetirement;
	}

	/**
	 * @param otherRetirement
	 *            The otherRetirement to set.
	 */
	public void setOtherRetirement(BigDecimal otherRetirement) {
		this.otherRetirement = otherRetirement;
	}

	/**
	 * @return Returns the realProperty.
	 */
	public BigDecimal getRealProperty() {
		return realProperty;
	}

	/**
	 * @param realProperty
	 *            The realProperty to set.
	 */
	public void setRealProperty(BigDecimal realProperty) {
		this.realProperty = realProperty;
	}

	/**
	 * @return Returns the socialSecurityNotSSIAmount.
	 */
	public BigDecimal getSocialSecurityNotSSIAmount() {
		return socialSecurityNotSSIAmount;
	}

	/**
	 * @param socialSecurityNotSSIAmount
	 *            The socialSecurityNotSSIAmount to set.
	 */
	public void setSocialSecurityNotSSIAmount(BigDecimal socialSecurityNotSSIAmount) {
		this.socialSecurityNotSSIAmount = socialSecurityNotSSIAmount;
	}

	/**
	 * @return Returns the stocksAndBonds.
	 */
	public BigDecimal getStocksAndBonds() {
		return stocksAndBonds;
	}

	/**
	 * @param stocksAndBonds
	 *            The stocksAndBonds to set.
	 */
	public void setStocksAndBonds(BigDecimal stocksAndBonds) {
		this.stocksAndBonds = stocksAndBonds;
	}

	/**
	 * @return Returns the totalIncomeFromEmployment.
	 */
	public BigDecimal getTotalIncomeFromEmployment() {
		return totalIncomeFromEmployment;
	}

	/**
	 * @param totalIncomeFromEmployment
	 *            The totalIncomeFromEmployment to set.
	 */
	public void setTotalIncomeFromEmployment(BigDecimal totalIncomeFromEmployment) {
		this.totalIncomeFromEmployment = totalIncomeFromEmployment;
	}

	/**
	 * @return Returns the unemploymentCompensation.
	 */
	public BigDecimal getUnemploymentCompensation() {
		return unemploymentCompensation;
	}

	/**
	 * @param unemploymentCompensation
	 *            The unemploymentCompensation to set.
	 */
	public void setUnemploymentCompensation(BigDecimal unemploymentCompensation) {
		this.unemploymentCompensation = unemploymentCompensation;
	}

	/**
	 * @return Returns the uSCivilService.
	 */
	public BigDecimal getUSCivilService() {
		return USCivilService;
	}

	/**
	 * @param civilService
	 *            The uSCivilService to set.
	 */
	public void setUSCivilService(BigDecimal civilService) {
		USCivilService = civilService;
	}

	/**
	 * @return Returns the uSRailroadRetirement.
	 */
	public BigDecimal getUSRailroadRetirement() {
		return USRailroadRetirement;
	}

	/**
	 * @param railroadRetirement
	 *            The uSRailroadRetirement to set.
	 */
	public void setUSRailroadRetirement(BigDecimal railroadRetirement) {
		USRailroadRetirement = railroadRetirement;
	}

	/**
	 * @return Returns the workersCompBlackLung.
	 */
	public BigDecimal getWorkersCompBlackLung() {
		return workersCompBlackLung;
	}

	/**
	 * @param workersCompBlackLung
	 *            The workersCompBlackLung to set.
	 */
	public void setWorkersCompBlackLung(BigDecimal workersCompBlackLung) {
		this.workersCompBlackLung = workersCompBlackLung;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		// TODO Auto-generated method stub

	}
	
	void addDependentRawFileData(OrderedMap map) {
		addRawFileData(map, true);
	}
	
	void addRawFileData(OrderedMap map) {
		addRawFileData(map, false);
	}
	
	void addRawFileData(OrderedMap map, boolean isDependent) {
		map.put("socialSecurityNotSSIAmount", this.socialSecurityNotSSIAmount);
		map.put("USCivilService", this.USCivilService);
		map.put("USRailroadRetirement", this.USRailroadRetirement);
		map.put("militaryRetirement", this.militaryRetirement);
		map.put("unemploymentCompensation", this.unemploymentCompensation);
		map.put("otherRetirement", this.otherRetirement);
		map.put("totalIncomeFromEmployment", this.totalIncomeFromEmployment);
		map.put("interestDividendAnnuity", this.interestDividendAnnuity);
		map.put("workersCompBlackLung", this.workersCompBlackLung);
		map.put("allOtherIncome", this.allOtherIncome);
		if(!isDependent) {
			map.put("medicalExpenses", this.medicalExpenses);
			map.put("funeralAndBurialExpenses", this.funeralAndBurialExpenses);
		}
		map.put("educationExpenses", this.educationExpenses);
		map.put("cashInBank", this.cashInBank);
		map.put("stocksAndBonds", this.stocksAndBonds);
		map.put("realProperty", this.realProperty);
		map.put("otherPropertyAndAssets", this.otherPropertyAndAssets);
		map.put("debts", this.debts);
	}	
}
