/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess.datasync;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.lookup.CancelDeclineReason;
import gov.va.med.esr.common.model.lookup.EnrollmentCategory;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentSource;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;



/**
 * Initial javadoc for class HECLegacyEnrollmentFileData.
 * TODO - Add content here
 * 
 * Created Mar 14, 2006 10:15:50 PM
 * @author DNS   BOHMEG
 */
public class HECLegacyEnrollmentFileData extends AbstractRawFileDataContainer {
	/**
	 * 
	 */
	private static final long serialVersionUID = 7845102091600278808L;
	private ImpreciseDate effectiveDateOfChange;
	private EnrollmentSource enrollmentSource;	
	private EnrollmentStatus enrollmentStatus;
	private EGTSetting egtSetting = new EGTSetting();
	private String enrollmentStatusOverride;
	private CancelDeclineReason cancelDeclineReason;
	private EnrollmentPriorityGroup enrollmentPriorityGroup;
	private EnrollmentPrioritySubGroup enrollmentPrioritySubgroup;
	private ImpreciseDate applicationDate;
	private String cancelDeclineRemarks;
	private VAFacility preferredFacility;
	private ImpreciseDate enrollmentDate;
	private ImpreciseDate enrollmentEndDate;
	private EnrollmentCategory enrollmentCategory;
	
	static {
		RawFileDataContainerUtils.autoRegisterConvertersForClass();
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		// TODO Auto-generated method stub

	}

	/**
	 * @return Returns the effectiveDateOfChange.
	 */
	public ImpreciseDate getEffectiveDateOfChange() {
		return effectiveDateOfChange;
	}

	/**
	 * @param effectiveDateOfChange The effectiveDateOfChange to set.
	 */
	public void setEffectiveDateOfChange(ImpreciseDate effectiveDateOfChange) {
		this.effectiveDateOfChange = effectiveDateOfChange;
	}

	/**
	 * @return Returns the enrollmentDate.
	 */
	public ImpreciseDate getEnrollmentDate() {
		return enrollmentDate;
	}

	/**
	 * @param enrollmentDate The enrollmentDate to set.
	 */
	public void setEnrollmentDate(ImpreciseDate enrollmentDate) {
		this.enrollmentDate = enrollmentDate;
	}

	/**
	 * @return Returns the enrollmentEndDate.
	 */
	public ImpreciseDate getEnrollmentEndDate() {
		return enrollmentEndDate;
	}

	/**
	 * @param enrollmentEndDate The enrollmentEndDate to set.
	 */
	public void setEnrollmentEndDate(ImpreciseDate enrollmentEndDate) {
		this.enrollmentEndDate = enrollmentEndDate;
	}

	/**
	 * @return Returns the enrollmentPriorityGroup.
	 */
	public EnrollmentPriorityGroup getEnrollmentPriorityGroup() {
		return enrollmentPriorityGroup;
	}

	/**
	 * @param enrollmentPriorityGroup The enrollmentPriorityGroup to set.
	 */
	public void setEnrollmentPriorityGroup(
			EnrollmentPriorityGroup enrollmentPriorityGroup) {
		this.enrollmentPriorityGroup = enrollmentPriorityGroup;
	}


	/**
	 * @return Returns the enrollmentSource.
	 */
	public EnrollmentSource getEnrollmentSource() {
		return enrollmentSource;
	}

	/**
	 * @param enrollmentSource The enrollmentSource to set.
	 */
	public void setEnrollmentSource(EnrollmentSource enrollmentSource) {
		this.enrollmentSource = enrollmentSource;
	}

	/**
	 * @return Returns the enrollmentStatus.
	 */
	public EnrollmentStatus getEnrollmentStatus() {
		return enrollmentStatus;
	}

	/**
	 * @param enrollmentStatus The enrollmentStatus to set.
	 */
	public void setEnrollmentStatus(EnrollmentStatus enrollmentStatus) {
		this.enrollmentStatus = enrollmentStatus;
	}

	/**
	 * @return Returns the enrollmentStatusOverride.
	 */
	public String getEnrollmentStatusOverride() {
		return enrollmentStatusOverride;
	}

	/**
	 * @param enrollmentStatusOverride The enrollmentStatusOverride to set.
	 */
	public void setEnrollmentStatusOverride(String enrollmentStatusOverride) {
		this.enrollmentStatusOverride = enrollmentStatusOverride;
	}

	/**
	 * @return Returns the preferredFacility.
	 */
	public VAFacility getPreferredFacility() {
		return preferredFacility;
	}

	/**
	 * @param preferredFacility The preferredFacility to set.
	 */
	public void setPreferredFacility(VAFacility preferredFacility) {
		this.preferredFacility = preferredFacility;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.parser.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow)
	 */
	public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
		int i=1; // ignore first element (data type)
		RawFileDataContainerUtils.setConvertedField(this, "effectiveDateOfChange", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "enrollmentSource", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "enrollmentStatus", parsedRow.getString(i++));
		parseEGTSettings(parsedRow.getString(i++));
		enrollmentStatusOverride = parsedRow.getString(i++);
		RawFileDataContainerUtils.setConvertedField(this, "cancelDeclineReason", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "enrollmentPriorityGroup", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "enrollmentPrioritySubgroup", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "applicationDate", parsedRow.getString(i++));
		cancelDeclineRemarks = parsedRow.getString(i++);
		RawFileDataContainerUtils.setConvertedField(this, "preferredFacility", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "enrollmentDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "enrollmentEndDate;", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "enrollmentCategory;", parsedRow.getString(i++));		
	}
	
	
	private void parseEGTSettings(String egtSettingsString) throws Exception {
		if(StringUtils.isBlank(egtSettingsString))
			return;

		String[] tokens = egtSettingsString.split("\\" + HECLegacyDataSynchronizationConstants.Delimiters.SECONDARY);
		if(tokens != null && tokens.length == 3) {
			egtSetting.setPriorityGroup((EnrollmentPriorityGroup) RawFileDataContainerUtils.convertToLookup(EnrollmentPriorityGroup.class, tokens[0]));
			egtSetting.setPrioritySubGroup((EnrollmentPrioritySubGroup) RawFileDataContainerUtils.convertToLookup(EnrollmentPrioritySubGroup.class, tokens[1]));
			RawFileDataContainerUtils.setConvertedField(egtSetting, "effectiveDate", tokens[2]);
		}
	}
	

	/**
	 * @return Returns the cancelDeclineReason.
	 */
	public CancelDeclineReason getCancelDeclineReason() {
		return cancelDeclineReason;
	}

	/**
	 * @param cancelDeclineReason The cancelDeclineReason to set.
	 */
	public void setCancelDeclineReason(CancelDeclineReason cancelDeclineReason) {
		this.cancelDeclineReason = cancelDeclineReason;
	}

	/**
	 * @return Returns the cancelDeclineRemarks.
	 */
	public String getCancelDeclineRemarks() {
		return cancelDeclineRemarks;
	}

	/**
	 * @param cancelDeclineRemarks The cancelDeclineRemarks to set.
	 */
	public void setCancelDeclineRemarks(String cancelDeclineRemarks) {
		this.cancelDeclineRemarks = cancelDeclineRemarks;
	}

	/**
	 * @return Returns the enrollmentPrioritySubgroup.
	 */
	public EnrollmentPrioritySubGroup getEnrollmentPrioritySubgroup() {
		return enrollmentPrioritySubgroup;
	}

	/**
	 * @param enrollmentPrioritySubgroup The enrollmentPrioritySubgroup to set.
	 */
	public void setEnrollmentPrioritySubgroup(
			EnrollmentPrioritySubGroup enrollmentPrioritySubgroup) {
		this.enrollmentPrioritySubgroup = enrollmentPrioritySubgroup;
	}

	/**
	 * @return Returns the applicationDate.
	 */
	public ImpreciseDate getApplicationDate() {
		return applicationDate;
	}

	/**
	 * @param applicationDate The applicationDate to set.
	 */
	public void setApplicationDate(ImpreciseDate applicationDate) {
		this.applicationDate = applicationDate;
	}

	/**
	 * @return Returns the egtSetting.
	 */
	public EGTSetting getEgtSetting() {
		return egtSetting;
	}

	/**
	 * @param egtSetting The egtSetting to set.
	 */
	public void setEgtSetting(EGTSetting egtSetting) {
		this.egtSetting = egtSetting;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
	 */
	public OrderedMap getRawFileData() throws Exception {
		OrderedMap map = new ListOrderedMap();
		map.put("header", HECLegacyDataSynchronizationConstants.DataTypes.ENROLLMENT_DATA_TYPE);
		map.put("effectiveDateOfChange", this.effectiveDateOfChange);
		map.put("enrollmentSource", this.enrollmentSource);
		map.put("enrollmentStatus", this.enrollmentStatus);
		map.put("EGTSetting", this.egtSetting);
		map.put("enrollmentStatusOverride", this.enrollmentStatusOverride);
		map.put("cancelDeclineReason", this.cancelDeclineReason);
		map.put("enrollmentPriorityGroup", this.enrollmentPriorityGroup);
		map.put("enrollmentPrioritySubgroup", this.enrollmentPrioritySubgroup);
		map.put("applicationDate", this.applicationDate);
		map.put("cancelDeclineRemarks", this.cancelDeclineRemarks);
		map.put("preferredFacility", this.preferredFacility);
		map.put("enrollmentDate", this.enrollmentDate);
		map.put("enrollmentEndDate", this.enrollmentEndDate);
		map.put("enrollmentCategory", this.enrollmentCategory);
		return map;
	}

	/**
	 * @return Returns the enrollmentCategory.
	 */
	public EnrollmentCategory getEnrollmentCategory() {
		return enrollmentCategory;
	}

	/**
	 * @param enrollmentCategory The enrollmentCategory to set.
	 */
	public void setEnrollmentCategory(EnrollmentCategory enrollmentCategory) {
		this.enrollmentCategory = enrollmentCategory;
	}
}
