/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess.datasync;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

import gov.va.med.fw.io.FieldTransformer;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.builder.Builder;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.EGTSetting;

/**
 * Initial javadoc for class HECLegacyEGTSettingFieldTransformer.
 * TODO - Add content here
 * 
 * Created Apr 19, 2006 9:53:28 PM
 * @author DNS   BOHMEG
 */
public class HECLegacyEGTSettingFieldTransformer extends AbstractComponent
		implements FieldTransformer {
	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.FieldTransformer#transformData(java.lang.String, java.lang.Object)
	 */
	public Object transformData(String fieldName, Object data) throws Exception {
		EGTSetting egt = (EGTSetting) data;
		StringBuffer buf = new StringBuffer();
		buf.append(RawFileDataContainerUtils.formatLookup(egt.getPriorityGroup()));
		buf.append(HECLegacyDataSynchronizationConstants.Delimiters.SECONDARY);
		buf.append(RawFileDataContainerUtils.formatLookup(egt.getPrioritySubGroup()));
		buf.append(HECLegacyDataSynchronizationConstants.Delimiters.SECONDARY);		
		if(egt.getEffectiveDate() != null)
			buf.append(new ImpreciseDate(egt.getEffectiveDate()).toStandardFormat());
		else
			buf.append(StringUtils.EMPTY);
		return buf.toString();
	}
}
