/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess.datasync;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.PseudoSSNReason;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.person.Name;

/**
 * Initial javadoc for class HECLegacyDependentFinancialFileData.
 * TODO - Add content here
 * 
 * Created Mar 29, 2006 1:54:25 PM
 * @author DNS   BOHMEG
 */
public class HECLegacyDependentFinancialFileData extends AbstractRawFileDataContainer {
	/**
	 * 
	 */
	private static final long serialVersionUID = -4396484945289268899L;
	private Integer incomeYear;
	private Name name = new Name();
	private String degree;
	private Gender gender;
	private ImpreciseDate dateOfBirth;
	private String SSN;
	private Relationship relationship;
	private String maidenName;
	private ImpreciseDate effectiveDate;
	private HECLegacyFinancialAmountsFileData financialAmounts = new HECLegacyFinancialAmountsFileData();
	private String livedWithPatient;
	private String incapableOfSelfSupport;
	private String contributedToSupport;
	private String childHadIncome;
	private String incomeAvailable;
	private BigDecimal amountContributedToSpouse;
	private PseudoSSNReason pseudoSSNReason;
	
	static {
		RawFileDataContainerUtils.autoRegisterConvertersForClass();
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.parser.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow)
	 */
	public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping)
			throws Exception {
		int i=1; // ignore first element (data type)
		
		int nameDataIndex = 0;
		List nameData = RawFileDataContainerUtils.parseMultipleValues(parsedRow.getString(i++), HECLegacyDataSynchronizationConstants.Delimiters.TERTIARY);
		if(nameData.size() > nameDataIndex)
			name.setFamilyName((String) nameData.get(nameDataIndex++));
		if(nameData.size() > nameDataIndex)
			name.setGivenName((String)nameData.get(nameDataIndex++));
		if(nameData.size() > nameDataIndex)		
			name.setMiddleName((String) nameData.get(nameDataIndex++));
		if(nameData.size() > nameDataIndex)		
			name.setSuffix((String) nameData.get(nameDataIndex++));
		if(nameData.size() > nameDataIndex)		
			name.setPrefix((String) nameData.get(nameDataIndex++));
		if(nameData.size() > nameDataIndex)
			degree = (String) nameData.get(nameDataIndex++);
		
		RawFileDataContainerUtils.setConvertedField(this, "gender", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "dateOfBirth", parsedRow.getString(i++));
		SSN = parsedRow.getString(i++);
		RawFileDataContainerUtils.setConvertedField(this, "relationship", parsedRow.getString(i++));
		maidenName = parsedRow.getString(i++);
		RawFileDataContainerUtils.setConvertedField(this, "effectiveDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "socialSecurityNotSSIAmount", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "USCivilService", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "USRailroadRetirement", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "militaryRetirement", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "unemploymentCompensation", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "otherRetirement", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "totalIncomeFromEmployment", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "interestDividendAnnuity", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "workersCompBlackLung", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "allOtherIncome", parsedRow.getString(i++));
		/*RawFileDataContainerUtils.setConvertedField(financialAmounts, "medicalExpenses", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "funeralAndBurialExpenses", parsedRow.getString(i++));*/
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "educationExpenses", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "cashInBank", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "stocksAndBonds", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "realProperty", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "otherPropertyAndAssets", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(financialAmounts, "debts", parsedRow.getString(i++));				
		livedWithPatient = parsedRow.getString(i++);
		incapableOfSelfSupport = parsedRow.getString(i++);
		contributedToSupport = parsedRow.getString(i++);
		childHadIncome = parsedRow.getString(i++);
		incomeAvailable = parsedRow.getString(i++);
		RawFileDataContainerUtils.setConvertedField(this, "amountContributedToSpouse", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "pseudoSSNReason", parsedRow.getString(i++));
	}

	/**
	 * @return Returns the amountContributedToSpouse.
	 */
	public BigDecimal getAmountContributedToSpouse() {
		return amountContributedToSpouse;
	}

	/**
	 * @param amountContributedToSpouse The amountContributedToSpouse to set.
	 */
	public void setAmountContributedToSpouse(BigDecimal amountContributedToSpouse) {
		this.amountContributedToSpouse = amountContributedToSpouse;
	}

	/**
	 * @return Returns the childHadIncome.
	 */
	public String getChildHadIncome() {
		return childHadIncome;
	}

	/**
	 * @param childHadIncome The childHadIncome to set.
	 */
	public void setChildHadIncome(String childHadIncome) {
		this.childHadIncome = childHadIncome;
	}

	/**
	 * @return Returns the contributedToSupport.
	 */
	public String getContributedToSupport() {
		return contributedToSupport;
	}

	/**
	 * @param contributedToSupport The contributedToSupport to set.
	 */
	public void setContributedToSupport(String contributedToSupport) {
		this.contributedToSupport = contributedToSupport;
	}

	/**
	 * @return Returns the incapableOfSelfSupport.
	 */
	public String getIncapableOfSelfSupport() {
		return incapableOfSelfSupport;
	}

	/**
	 * @param incapableOfSelfSupport The incapableOfSelfSupport to set.
	 */
	public void setIncapableOfSelfSupport(String incapableOfSelfSupport) {
		this.incapableOfSelfSupport = incapableOfSelfSupport;
	}

	/**
	 * @return Returns the incomeAvailable.
	 */
	public String getIncomeAvailable() {
		return incomeAvailable;
	}

	/**
	 * @param incomeAvailable The incomeAvailable to set.
	 */
	public void setIncomeAvailable(String incomeAvailable) {
		this.incomeAvailable = incomeAvailable;
	}

	/**
	 * @return Returns the livedWithPatient.
	 */
	public String getLivedWithPatient() {
		return livedWithPatient;
	}

	/**
	 * @param livedWithPatient The livedWithPatient to set.
	 */
	public void setLivedWithPatient(String livedWithPatient) {
		this.livedWithPatient = livedWithPatient;
	}

	/**
	 * @return Returns the maidenName.
	 */
	public String getMaidenName() {
		return maidenName;
	}

	/**
	 * @param maidenName The maidenName to set.
	 */
	public void setMaidenName(String maidenName) {
		this.maidenName = maidenName;
	}

	/**
	 * @return Returns the dateOfBirth.
	 */
	public ImpreciseDate getDateOfBirth() {
		return dateOfBirth;
	}

	/**
	 * @param dateOfBirth The dateOfBirth to set.
	 */
	public void setDateOfBirth(ImpreciseDate dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}

	/**
	 * @return Returns the effectiveDate.
	 */
	public ImpreciseDate getEffectiveDate() {
		return effectiveDate;
	}

	/**
	 * @param effectiveDate The effectiveDate to set.
	 */
	public void setEffectiveDate(ImpreciseDate effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	/**
	 * @return Returns the gender.
	 */
	public Gender getGender() {
		return gender;
	}

	/**
	 * @param gender The gender to set.
	 */
	public void setGender(Gender gender) {
		this.gender = gender;
	}

	/**
	 * @return Returns the name.
	 */
	public Name getName() {
		return name;
	}

	/**
	 * @param name The name to set.
	 */
	public void setName(Name name) {
		this.name = name;
	}

	/**
	 * @return Returns the relationship.
	 */
	public Relationship getRelationship() {
		return relationship;
	}

	/**
	 * @param relationship The relationship to set.
	 */
	public void setRelationship(Relationship relationship) {
		this.relationship = relationship;
	}

	/**
	 * @return Returns the sSN.
	 */
	public String getSSN() {
		return SSN;
	}

	/**
	 * @param ssn The sSN to set.
	 */
	public void setSSN(String ssn) {
		SSN = ssn;
	}

	/**
	 * @return Returns the financialAmounts.
	 */
	public HECLegacyFinancialAmountsFileData getFinancialAmounts() {
		return financialAmounts;
	}

	/**
	 * @param financialAmounts The financialAmounts to set.
	 */
	public void setFinancialAmounts(
			HECLegacyFinancialAmountsFileData financialAmounts) {
		this.financialAmounts = financialAmounts;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
	 */
	public OrderedMap getRawFileData() throws Exception {
		OrderedMap map = new ListOrderedMap();
		map.put("header", HECLegacyDataSynchronizationConstants.DataTypes.DEPENDENT_FINANCIAL_DATA_TYPE);
		
		List nameData = new ArrayList();
		nameData.add(name != null ? StringUtils.trimToEmpty(name.getFamilyName()) : StringUtils.EMPTY);
		nameData.add(name != null ? StringUtils.trimToEmpty(name.getGivenName()) : StringUtils.EMPTY);
		nameData.add(name != null ? StringUtils.trimToEmpty(name.getMiddleName()) : StringUtils.EMPTY);
		nameData.add(name != null ? StringUtils.trimToEmpty(name.getSuffix()) : StringUtils.EMPTY);
		nameData.add(name != null ? StringUtils.trimToEmpty(name.getPrefix()) : StringUtils.EMPTY);
		nameData.add(StringUtils.isNotBlank(degree) ? degree : StringUtils.EMPTY);
		map.put("name", RawFileDataContainerUtils.formatMultipleValues(nameData, HECLegacyDataSynchronizationConstants.Delimiters.TERTIARY));
		
		map.put("gender", this.gender);
		map.put("dateOfBirth", this.dateOfBirth);
		map.put("SSN", this.SSN);
		map.put("relationship", this.relationship);
		map.put("maidenName", this.maidenName);
		map.put("effectiveDate", this.effectiveDate);
		financialAmounts.addDependentRawFileData(map);
		map.put("livedWithPatient", this.livedWithPatient);
		map.put("incapableOfSelfSupport", this.incapableOfSelfSupport);
		map.put("contributedToSupport", this.contributedToSupport);
		map.put("childHadIncome", this.childHadIncome);
		map.put("incomeAvailable", this.incomeAvailable);
		map.put("amountContributedToSpouse", this.amountContributedToSpouse);
		map.put("pseudoSSNReason", this.pseudoSSNReason);
		return map;
	}

	/**
	 * @return Returns the incomeYear.
	 */
	public Integer getIncomeYear() {
		return incomeYear;
	}

	/**
	 * @param incomeYear The incomeYear to set.
	 */
	public void setIncomeYear(Integer incomeYear) {
		this.incomeYear = incomeYear;
	}

	/**
	 * @return Returns the pseudoSSNReason.
	 */
	public PseudoSSNReason getPseudoSSNReason() {
		return pseudoSSNReason;
	}

	/**
	 * @param pseudoSSNReason The pseudoSSNReason to set.
	 */
	public void setPseudoSSNReason(PseudoSSNReason pseudoSSNReason) {
		this.pseudoSSNReason = pseudoSSNReason;
	}

	/**
	 * @return Returns the degree.
	 */
	public String getDegree() {
		return degree;
	}

	/**
	 * @param degree The degree to set.
	 */
	public void setDegree(String degree) {
		this.degree = degree;
	}
}
