/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess.datasync;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.DeathDataSource;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;

/**
 * Initial javadoc for class HECLegacyDemographicsFileData.
 * TODO - Add content here
 * 
 * Created Mar 14, 2006 10:15:03 PM
 * @author DNS   BOHMEG
 */
public class HECLegacyDemographicsFileData extends AbstractRawFileDataContainer {
	/**
	 * 
	 */
	private static final long serialVersionUID = 7026457752741239290L;
	private String claimFolderNumber;
	private VAFacility claimFolderLocation;
	private ImpreciseDate dateOfDeath;
	private VAFacility siteReportingDeath;
	private DeathDataSource sourceOfDeathNotification;
	private ImpreciseDate dateOfDeathLastUpdated;
	private Address address = new Address();
	private String addressChangedBy;
	private String residencePhone;
	private String workPhone;
	private String masterId;
	private String pseudoSSN;
	private ImpreciseDate SSNValidationDate;
	private SSAVerificationStatus SSNVerificationStatus;	
	private String sensitivityLevel;
	
	static {
		RawFileDataContainerUtils.autoRegisterConvertersForClass();
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		builder.append("address", address);
	}

	/**
	 * @return Returns the address.
	 */
	public Address getAddress() {
		return address;
	}

	/**
	 * @param address The address to set.
	 */
	public void setAddress(Address address) {
		this.address = address;
	}

	/**
	 * @return Returns the addressChangedBy.
	 */
	public String getAddressChangedBy() {
		return addressChangedBy;
	}

	/**
	 * @param addressChangedBy The addressChangedBy to set.
	 */
	public void setAddressChangedBy(String addressChangedBy) {
		this.addressChangedBy = addressChangedBy;
	}

	/**
	 * @return Returns the claimFolderNumber.
	 */
	public String getClaimFolderNumber() {
		return claimFolderNumber;
	}

	/**
	 * @param claimFolderNumber The claimFolderNumber to set.
	 */
	public void setClaimFolderNumber(String claimFolderNumber) {
		this.claimFolderNumber = claimFolderNumber;
	}


	/**
	 * @return Returns the masterId.
	 */
	public String getMasterId() {
		return masterId;
	}

	/**
	 * @param masterId The masterId to set.
	 */
	public void setMasterId(String masterId) {
		this.masterId = masterId;
	}

	/**
	 * @return Returns the pseudoSSN.
	 */
	public String getPseudoSSN() {
		return pseudoSSN;
	}

	/**
	 * @param pseudoSSN The pseudoSSN to set.
	 */
	public void setPseudoSSN(String pseudoSSN) {
		this.pseudoSSN = pseudoSSN;
	}


	/**
	 * @return Returns the residencePhone.
	 */
	public String getResidencePhone() {
		return residencePhone;
	}

	/**
	 * @param residencePhone The residencePhone to set.
	 */
	public void setResidencePhone(String residencePhone) {
		this.residencePhone = residencePhone;
	}

	/**
	 * @return Returns the sensitivityLevel.
	 */
	public String getSensitivityLevel() {
		return sensitivityLevel;
	}

	/**
	 * @param sensitivityLevel The sensitivityLevel to set.
	 */
	public void setSensitivityLevel(String sensitivityLevel) {
		this.sensitivityLevel = sensitivityLevel;
	}


	/**
	 * @return Returns the workPhone.
	 */
	public String getWorkPhone() {
		return workPhone;
	}

	/**
	 * @param workPhone The workPhone to set.
	 */
	public void setWorkPhone(String workPhone) {
		this.workPhone = workPhone;
	}

	/**
	 * @return Returns the dateOfDeath.
	 */
	public ImpreciseDate getDateOfDeath() {
		return dateOfDeath;
	}

	/**
	 * @param dateOfDeath The dateOfDeath to set.
	 */
	public void setDateOfDeath(ImpreciseDate dateOfDeath) {
		this.dateOfDeath = dateOfDeath;
	}


	/**
	 * @return Returns the dateOfDeathLastUpdated.
	 */
	public ImpreciseDate getDateOfDeathLastUpdated() {
		return dateOfDeathLastUpdated;
	}

	/**
	 * @param dateOfDeathLastUpdated The dateOfDeathLastUpdated to set.
	 */
	public void setDateOfDeathLastUpdated(ImpreciseDate dateOfDeathLastUpdated) {
		this.dateOfDeathLastUpdated = dateOfDeathLastUpdated;
	}

	/**
	 * @return Returns the siteReportingDeath.
	 */
	public VAFacility getSiteReportingDeath() {
		return siteReportingDeath;
	}

	/**
	 * @param siteReportingDeath The siteReportingDeath to set.
	 */
	public void setSiteReportingDeath(VAFacility siteReportingDeath) {
		this.siteReportingDeath = siteReportingDeath;
	}

	
	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.parser.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow)
	 */
	public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
		int i=1; // ignore first element (data type)
		claimFolderNumber = parsedRow.getString(i++);	
		RawFileDataContainerUtils.setConvertedField(this, "claimFolderLocation", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "dateOfDeath", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "siteReportingDeath", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "sourceOfDeathNotification", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "dateOfDeathLastUpdated", parsedRow.getString(i++));
		address.setLine1(parsedRow.getString(i++));
		address.setLine2(parsedRow.getString(i++));
		address.setCity(parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(address, "state", parsedRow.getString(i++));
		address.setZipCode(parsedRow.getString(i++));
		address.setZipPlus4(parsedRow.getString(i++));
		address.setCounty(parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(address, "changeDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(address, "changeSource", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(address, "changeSite", parsedRow.getString(i++));
		addressChangedBy = parsedRow.getString(i++);
		residencePhone = parsedRow.getString(i++);
		workPhone = parsedRow.getString(i++);
		masterId = parsedRow.getString(i++);
		pseudoSSN = parsedRow.getString(i++);
		
		// this is the placeholder for old pseudoSSNReason...until HECLegacy agrees to remove from ICD, must still ignore this entry
		parsedRow.getString(i++);  // note we ignore this value since it should never be populated
		
		RawFileDataContainerUtils.setConvertedField(this, "SSNValidationDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "SSNVerificationStatus", parsedRow.getString(i++));		
		sensitivityLevel = parsedRow.getString(i++);				
	}

	/**
	 * @return Returns the sSNValidationDate.
	 */
	public ImpreciseDate getSSNValidationDate() {
		return SSNValidationDate;
	}

	/**
	 * @param validationDate The sSNValidationDate to set.
	 */
	public void setSSNValidationDate(ImpreciseDate validationDate) {
		SSNValidationDate = validationDate;
	}

	/**
	 * @return Returns the sourceOfDeathNotification.
	 */
	public DeathDataSource getSourceOfDeathNotification() {
		return sourceOfDeathNotification;
	}

	/**
	 * @param sourceOfDeathNotification The sourceOfDeathNotification to set.
	 */
	public void setSourceOfDeathNotification(
			DeathDataSource sourceOfDeathNotification) {
		this.sourceOfDeathNotification = sourceOfDeathNotification;
	}

	/**
	 * @return Returns the claimFolderLocation.
	 */
	public VAFacility getClaimFolderLocation() {
		return claimFolderLocation;
	}

	/**
	 * @param claimFolderLocation The claimFolderLocation to set.
	 */
	public void setClaimFolderLocation(VAFacility claimFolderLocation) {
		this.claimFolderLocation = claimFolderLocation;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
	 */	
	public OrderedMap getRawFileData() throws Exception {
		OrderedMap map = new ListOrderedMap();
		map.put("header", HECLegacyDataSynchronizationConstants.DataTypes.DEMOGRAPHICS_DATA_TYPE);
		map.put("claimFolderNumber", this.claimFolderNumber);
		map.put("claimFolderLocation", this.claimFolderLocation);
		map.put("dateOfDeath", this.dateOfDeath);
		map.put("siteReportingDeath", this.siteReportingDeath);
		map.put("sourceOfDeathNotification", this.sourceOfDeathNotification);
		map.put("dateOfDeathLastUpdated", this.dateOfDeathLastUpdated);
		map.put("addressLine1", address.getLine1());
		if(StringUtils.isNotBlank(address.getLine2()) || StringUtils.isNotBlank(address.getLine3())) {
			String line2 = address.getLine2();
			String line3 = address.getLine3();
			map.put("addressLine2", (StringUtils.isNotBlank(line2) ? line2 : StringUtils.EMPTY) + " " + 
					(StringUtils.isNotBlank(line3) ? line3 : StringUtils.EMPTY));
		}
		else
			map.put("addressLine2", StringUtils.EMPTY);
		map.put("city", address.getCity());
		map.put("state", address.getState());
		map.put("zipCode", address.getZipCode());
		map.put("zipPlus4", address.getZipPlus4());
		map.put("county", address); // transformer needs entire Address
		map.put("addressChangeDate", address.getChangeDate());
		map.put("addressChangeSource", address.getChangeSource());
		map.put("addressChangeSite", address.getChangeSite());
		map.put("addressChangedBy", address.getModifiedBy() != null ? address.getModifiedBy().getName() : StringUtils.EMPTY);
		map.put("residencePhone", this.residencePhone);
		map.put("workPhone", workPhone);
		map.put("masterId", this.masterId);
		map.put("pseudoSSN", this.pseudoSSN);
		
		// this is the placeholder for old pseudoReason...until HECLegacy agrees to remove from ICD, must still write this entry
		map.put("pseudoSSNReason", StringUtils.EMPTY);
		
		map.put("SSNValidationDate", this.SSNValidationDate);
		map.put("SSNVerificationStatus", this.SSNVerificationStatus);
		map.put("sensitivityLevel", this.sensitivityLevel);
		return map;
	}

	/**
	 * @return Returns the sSNVerificationStatus.
	 */
	public SSAVerificationStatus getSSNVerificationStatus() {
		return SSNVerificationStatus;
	}

	/**
	 * @param verificationStatus The sSNVerificationStatus to set.
	 */
	public void setSSNVerificationStatus(SSAVerificationStatus verificationStatus) {
		SSNVerificationStatus = verificationStatus;
	}	
}
