/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.batchprocess.datasync;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

import gov.va.med.fw.io.FieldTransformer;
import gov.va.med.fw.service.AbstractComponent;

import gov.va.med.esr.common.batchprocess.DateFieldTransformer;
import gov.va.med.esr.common.infra.ImpreciseDate;

/**
 * Applies global transforms to all data produced for HECLegacy.
 * 
 * Created Apr 13, 2006 5:26:25 PM
 * 
 * @author DNS   BOHMEG
 */
public class HECLegacyDataSynchronizationProducerGlobalTransformer extends
		AbstractComponent implements FieldTransformer {
	private DateFieldTransformer impreciseDateTransformer;
	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.io.FieldTransformer#transformData(java.lang.String,
	 *      java.lang.Object)
	 */
	public Object transformData(String fieldName, Object data) throws Exception {
		if (data == null)
			return StringUtils.EMPTY;
		Object result = data;
		if (data instanceof ImpreciseDate)
			result = impreciseDateTransformer.transformData(fieldName, data);

		return result;
	}

	/**
	 * @return Returns the impreciseDateTransformer.
	 */
	public DateFieldTransformer getImpreciseDateTransformer() {
		return impreciseDateTransformer;
	}

	/**
	 * @param impreciseDateTransformer
	 *            The impreciseDateTransformer to set.
	 */
	public void setImpreciseDateTransformer(
			DateFieldTransformer impreciseDateTransformer) {
		this.impreciseDateTransformer = impreciseDateTransformer;
	}
	
	public void afterPropertiesSet() {
		Validate.notNull(impreciseDateTransformer, "An impreciseDateTransformer is required");
	}
}
