/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess.datasync;

import org.apache.commons.lang.StringUtils;

import gov.va.med.fw.io.FieldTransformer;
import gov.va.med.fw.service.AbstractComponent;

import gov.va.med.esr.common.model.lookup.County;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.UnknownLookupCodeException;

/**
 * Initial javadoc for class HECLegacyCountyCodeTransformer.
 * TODO - Add content here
 * 
 * Created May 19, 2006 3:36:43 PM
 * @author DNS   BOHMEG
 */
public class HECLegacyCountyCodeTransformer extends AbstractComponent implements
		FieldTransformer {
	private LookupService lookupService;

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.FieldTransformer#transformData(java.lang.String, java.lang.Object)
	 */
	public Object transformData(String fieldName, Object data) throws Exception {
		Object transformedValue = StringUtils.EMPTY;
		if(data != null) {
			Address add = (Address) data;
			// if not found via lookupService, send nothing (per ICD)
			//transformedValue = add.getCounty();
			try {
				County county = lookupService.getCountyByAddress(add);
				if(county != null)
					transformedValue = county.getCountyNumber();
			} catch(UnknownLookupCodeException e) {
				if(logger.isWarnEnabled())
					logger.warn("Unable to determine the County from Address: " + add);
			}
		}
		return transformedValue;
	}

	/**
	 * @return Returns the lookupService.
	 */
	public LookupService getLookupService() {
		return lookupService;
	}

	/**
	 * @param lookupService The lookupService to set.
	 */
	public void setLookupService(LookupService lookupService) {
		this.lookupService = lookupService;
	}

}
