/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess.datasync;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;

/**
 * Initial javadoc for class HECLegacyCommunicationsFileData.
 * TODO - Add content here
 * 
 * Created Mar 14, 2006 10:14:42 PM
 * @author DNS   BOHMEG
 */
public class HECLegacyCommunicationsFileData extends AbstractRawFileDataContainer {
	/**
	 * 
	 */
	private static final long serialVersionUID = -1444791276558809932L;
	private String letterForm;
	private String status;
	private String fileName;
	private String remail;
	private String actionMessage;
	
	static {
		RawFileDataContainerUtils.autoRegisterConvertersForClass();
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		// TODO Auto-generated method stub

	}

	/**
	 * @return Returns the actionMessage.
	 */
	public String getActionMessage() {
		return actionMessage;
	}

	/**
	 * @param actionMessage The actionMessage to set.
	 */
	public void setActionMessage(String actionMessage) {
		this.actionMessage = actionMessage;
	}

	/**
	 * @return Returns the fileName.
	 */
	public String getFileName() {
		return fileName;
	}

	/**
	 * @param fileName The fileName to set.
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * @return Returns the letterForm.
	 */
	public String getLetterForm() {
		return letterForm;
	}

	/**
	 * @param letterForm The letterForm to set.
	 */
	public void setLetterForm(String letterForm) {
		this.letterForm = letterForm;
	}

	/**
	 * @return Returns the remail.
	 */
	public String getRemail() {
		return remail;
	}

	/**
	 * @param remail The remail to set.
	 */
	public void setRemail(String remail) {
		this.remail = remail;
	}

	/**
	 * @return Returns the status.
	 */
	public String getStatus() {
		return status;
	}

	/**
	 * @param status The status to set.
	 */
	public void setStatus(String status) {
		this.status = status;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.parser.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow)
	 */
	public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) {
		int i=1; // ignore first element (data type)
		letterForm = parsedRow.getString(i++);
		status = parsedRow.getString(i++);
		fileName = parsedRow.getString(i++);
		remail = parsedRow.getString(i++);
		actionMessage = parsedRow.getString(i++);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
	 */
	public OrderedMap getRawFileData() throws Exception {
		OrderedMap map = new ListOrderedMap();
		map.put("header", HECLegacyDataSynchronizationConstants.DataTypes.COMMUNICATIONS_DATA_TYPE);
		map.put("letterForm", this.letterForm);
		map.put("status", this.status);
		map.put("fileName", this.fileName);
		map.put("remail", this.remail);
		map.put("actionMessage", this.actionMessage);

		return map;
	}
}
