/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess.datasync;

import java.util.Date;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.OEFOIFSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;

/**
 * Initial javadoc for class HECLegacyCombatFileData.
 * TODO - Add content here
 * 
 * Created Jul 27, 2006 3:15:44 PM
 * @author DNS   BOHMEG
 */
public class HECLegacyCombatFileData extends AbstractRawFileDataContainer {
	/**
	 * 
	 */
	private static final long serialVersionUID = -6281462425623056157L;
	private ConflictLocation conflictLocation;
	private ImpreciseDate combatFromDate;
	private ImpreciseDate combatToDate;
	private String hostileFireImminentDangerIndicator;
	private String ctzeIndicator;
	private OEFOIFSource dataSource;
	private VAFacility facility;
	private Date lastUpdated;	
	
	static {
		RawFileDataContainerUtils.autoRegisterConvertersForClass();
	}
	
	
	/* (non-Javadoc)
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		builder.append("conflictLocation", conflictLocation);
	}


	/**
	 * @return Returns the conflictLocation.
	 */
	public ConflictLocation getConflictLocation() {
		return conflictLocation;
	}

	/**
	 * @param conflictLocation The conflictLocation to set.
	 */
	public void setConflictLocation(ConflictLocation conflictLocation) {
		this.conflictLocation = conflictLocation;
	}

	/**
	 * @return Returns the ctzeIndicator.
	 */
	public String getCtzeIndicator() {
		return ctzeIndicator;
	}

	/**
	 * @param ctzeIndicator The ctzeIndicator to set.
	 */
	public void setCtzeIndicator(String ctzeIndicator) {
		this.ctzeIndicator = ctzeIndicator;
	}

	/**
	 * @return Returns the dataSource.
	 */
	public OEFOIFSource getDataSource() {
		return dataSource;
	}

	/**
	 * @param dataSource The dataSource to set.
	 */
	public void setDataSource(OEFOIFSource dataSource) {
		this.dataSource = dataSource;
	}

	/**
	 * @return Returns the hostileFireImminentDangerIndicator.
	 */
	public String getHostileFireImminentDangerIndicator() {
		return hostileFireImminentDangerIndicator;
	}

	/**
	 * @param hostileFireImminentDangerIndicator The hostileFireImminentDangerIndicator to set.
	 */
	public void setHostileFireImminentDangerIndicator(
			String hostileFireImminentDangerIndicator) {
		this.hostileFireImminentDangerIndicator = hostileFireImminentDangerIndicator;
	}

	/**
	 * @return Returns the lastUpdated.
	 */
	public Date getLastUpdated() {
		return lastUpdated;
	}

	/**
	 * @param lastUpdated The lastUpdated to set.
	 */
	public void setLastUpdated(Date lastUpdated) {
		this.lastUpdated = lastUpdated;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow, gov.va.med.fw.io.ClassMapping)
	 */
	public void setRawFileData(String rawFileData, DataRow parsedRow,
			ClassMapping classMapping) throws Exception {
		int i=1; // ignore first element (data type)	
		RawFileDataContainerUtils.setConvertedField(this, "conflictLocation", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "combatFromDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(this, "combatToDate", parsedRow.getString(i++));
		hostileFireImminentDangerIndicator = parsedRow.getString(i++);
		ctzeIndicator = parsedRow.getString(i++);
		String[] dataSourceAndFacility = (String[]) RawFileDataContainerUtils.parseMultipleValues(parsedRow.getString(i++), 
				HECLegacyDataSynchronizationConstants.Delimiters.SECONDARY).toArray(new String[2]);
		RawFileDataContainerUtils.setConvertedField(this, "dataSource", dataSourceAndFacility[0]);
		if(dataSourceAndFacility.length == 2)
			RawFileDataContainerUtils.setConvertedField(this, "facility", dataSourceAndFacility[1]);
		RawFileDataContainerUtils.setConvertedField(this, "lastUpdated", parsedRow.getString(i++));
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
	 */
	public OrderedMap getRawFileData() throws Exception {
		OrderedMap map = new ListOrderedMap();
		map.put("header", HECLegacyDataSynchronizationConstants.DataTypes.COMBAT_DATA_TYPE);
		map.put("conflictLocation", this.conflictLocation);
		map.put("combatFromDate", this.combatFromDate);
		map.put("combatToDate", this.combatToDate);
		map.put("hostileFireImminentDangerIndicator", this.hostileFireImminentDangerIndicator);
		map.put("ctzeIndicator", this.ctzeIndicator);
		// ICD states to combine dataSource and facility (if both present for VAMC)
		if(dataSource != null && OEFOIFSource.CODE_VAMC.getCode().equals(dataSource.getCode()) &&
				facility != null) {
			map.put("dataSource", this.dataSource.getCode() + HECLegacyDataSynchronizationConstants.Delimiters.SECONDARY +
					facility.getStationNumber());
		} else {
			map.put("dataSource", this.dataSource);
		}
		map.put("lastUpdated", this.lastUpdated);

		return map;
	}


	/**
	 * @return Returns the combatFromDate.
	 */
	public ImpreciseDate getCombatFromDate() {
		return combatFromDate;
	}


	/**
	 * @param combatFromDate The combatFromDate to set.
	 */
	public void setCombatFromDate(ImpreciseDate combatFromDate) {
		this.combatFromDate = combatFromDate;
	}


	/**
	 * @return Returns the combatToDate.
	 */
	public ImpreciseDate getCombatToDate() {
		return combatToDate;
	}


	/**
	 * @param combatToDate The combatToDate to set.
	 */
	public void setCombatToDate(ImpreciseDate combatToDate) {
		this.combatToDate = combatToDate;
	}


	/**
	 * @return Returns the facility.
	 */
	public VAFacility getFacility() {
		return facility;
	}


	/**
	 * @param facility The facility to set.
	 */
	public void setFacility(VAFacility facility) {
		this.facility = facility;
	}	
}
