/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess.datasync;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractEntity;

/**
 * Initial javadoc for class DataSynchronizationProducerStatistics.
 * TODO - Add content here
 * 
 * Created Apr 18, 2006 5:53:52 PM
 * @author DNS   BOHMEG
 */
public class DataSynchronizationProducerStatistics extends
	AbstractEntity {
	private static final long serialVersionUID = 2400110589550083242L;
    
    private String fileName;
	private int entityCount;
	private int objectCount;
	private Date startTime;
	private Date endTime;
	private List fileData = new ArrayList();
	
	public void addFileData(Object obj) {
		fileData.add(obj);
	}
	
	public void incrementEntityCount() {
		entityCount++;
	}
	

	public void incrementObjectCount() {
		incrementObjectCount(1);
	}

	public void incrementObjectCount(int count) {
		objectCount += count;
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		// TODO Auto-generated method stub
		
	}

	/**
	 * @return Returns the entityCount.
	 */
	public int getEntityCount() {
		return entityCount;
	}

	/**
	 * @param entityCount The entityCount to set.
	 */
	public void setEntityCount(int entityCount) {
		this.entityCount = entityCount;
	}

	/**
	 * @return Returns the fileName.
	 */
	public String getFileName() {
		return fileName;
	}

	/**
	 * @param fileName The fileName to set.
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * @return Returns the objectCount.
	 */
	public int getObjectCount() {
		return objectCount;
	}

	/**
	 * @param objectCount The objectCount to set.
	 */
	public void setObjectCount(int objectCount) {
		this.objectCount = objectCount;
	}

	/**
	 * @return Returns the endTime.
	 */
	public Date getEndTime() {
		return endTime;
	}

	/**
	 * @param endTime The endTime to set.
	 */
	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	/**
	 * @return Returns the startTime.
	 */
	public Date getStartTime() {
		return startTime;
	}

	/**
	 * @param startTime The startTime to set.
	 */
	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}


	/**
	 * @return Returns the fileData.
	 */
	public List getFileData() {
		return fileData;
	}


	/**
	 * @param fileData The fileData to set.
	 */
	public void setFileData(List fileData) {
		this.fileData = fileData;
	}

}
