/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.batchprocess;

import java.util.Iterator;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.SignatureImage;

/**
 * Initial javadoc for class SignatureFileData. TODO - Add content here
 * 
 * Created Feb 2, 2006 4:54:41 PM
 * 
 * @author DNS   BOHMEG
 */
public class SignatureFileData extends SignatureImage {
	

    private static final long serialVersionUID = 2845144620739400887L;

    private String ssn;

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("ssn", ssn);
	}


	/**
	 * @return Returns the ssn.
	 */
	public String getSsn() {
		return ssn;
	}

	/**
	 * @param ssn The ssn to set.
	 */
	public void setSsn(String ssn) {
		this.ssn = ssn;
	}
	
	public SSN getSSNWrapper() {
		SSN obj = new SSN();
		obj.setSsnText(ssn);
		return obj;
	}
	
	public SignatureImage getSignatureImage() throws Exception {
		SignatureImage image = new SignatureImage();
		image.setDateIndex(this.getDateIndex());
		image.setImageIdNumber(this.getImageIdNumber());
		image.setIncomeYear(this.getIncomeYear());
		image.setSignatureIndicator(this.getSignatureIndicator());
		image.setSiteSubmittingImage(this.getSiteSubmittingImage());
		image.setUser(this.getUser());
		return image;
	}
}
