package gov.va.med.esr.common.batchprocess;

import java.util.Date;

import gov.va.med.fw.io.FileNameAppender;
import gov.va.med.fw.util.DateUtils;
/**
 * 
 * @author Rajiv Patnaik
 * Created on Mar 1, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class SendNCOAAddressFileNameAppender implements FileNameAppender
{
    
    private String fileExtension;
    
    /* (non-Javadoc)
     * @see gov.va.med.fw.io.FileNameAppender#getFileNameSuffix(java.lang.Object)
     */
    public String getFileNameSuffix(Object obj)
    {
        //Append the quarter and the filenumber. Will always be 1 since there
        //will be only one file
        return DateUtils.getQuarter(new Date()) + "01" + fileExtension ;
    }
    
    /**
     * @return Returns the fileExtension.
     */
    public String getFileExtension()
    {
        return fileExtension;
    }
    /**
     * @param fileExtension The fileExtension to set.
     */
    public void setFileExtension(String fileExtension)
    {
        this.fileExtension = fileExtension;
    }
}
