/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.service.trigger.EGTTriggerEvent;
import gov.va.med.fw.batchprocess.AbstractDataQueryProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.service.trigger.TriggerRouter;

import java.util.List;

import org.apache.commons.lang.Validate;

/**
 * Batch Process to trigger MFN~ZEG when the new EGT Setting is to be activated.
 * 
 * @author DNS   MANSOG
 */
public class SendMfnZegProcess extends AbstractDataQueryProcess {
	private TriggerRouter triggerRouter = null;
	/**
	 * @see gov.va.med.fw.batchprocess.AbstractDataProcess#processData(gov.va.med.fw.batchprocess.DataProcessExecutionContext,
	 *      java.util.List)
	 */
	protected void processData(DataProcessExecutionContext context, List acquiredData) {
		if(logger.isInfoEnabled())
			logger.info("Send MFN~ZEG batch process: Query result Size="+(acquiredData == null ? 0 : acquiredData.size()));
		
		if (acquiredData == null || acquiredData.size() == 0)
			return;
		
		EGTSetting egt = (EGTSetting)acquiredData.get(0);
		
		EGTTriggerEvent egtTriggerEvent = new EGTTriggerEvent(egt);
		try {
			triggerRouter.processTriggerEvent(egtTriggerEvent);
			
			if(logger.isDebugEnabled()) {
				logger.debug("Send MFN~ZEG batch process: MFN message triggered.");
			}
		} catch (Exception ex) {
			throw new IllegalStateException("Error triggering MFN message. Reason: "+ex);
		}
	}
	
	public void afterPropertiesSet() {
		super.afterPropertiesSet();
		Validate.notNull(triggerRouter, "A TriggerRouter is needed");
	}	

	/**
	 * @return Returns the triggerRouter.
	 */
	public TriggerRouter getTriggerRouter() {
		return triggerRouter;
	}
	
	/**
	 * @param triggerRouter The triggerRouter to set.
	 */
	public void setTriggerRouter(TriggerRouter triggerRouter) {
		this.triggerRouter = triggerRouter;
	}
}
