package gov.va.med.esr.common.batchprocess;

import java.util.List;
import java.util.Set;

import gov.va.med.esr.common.model.person.SSNVerification;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
/**
 * Additional context info needed for the SSN Verification processes.
 * 
 * @author Rajiv Patnaik
 * Created on Mar 9, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class SSNVerificationProcessExecutionContext extends
        DataQueryProcessExecutionContext
{ 
    private static final long serialVersionUID = 109606571332386030L;

    private SSNVerification ssnVerification = null;
    
    private Set vpidKeys;
    
    private boolean hasNoSpouseDependents;
    
    private boolean veteranDataProcessed; 
    
    //CCR 11666
    private boolean veteranDataAcquired;
    
    private List vetFileOutputData;
    
    private boolean reachMaxSize;
    
     
    /**
     * @return Returns the hasNoSpouseDependents.
     */
    public boolean hasNoSpouseDependents()
    {
        return hasNoSpouseDependents;
    }
    /**
     * @param hasNoSpouseDependents The hasNoSpouseDependents to set.
     */
    public void setHasNoSpouseDependents(boolean hasNoSpouseDependents)
    {
        this.hasNoSpouseDependents = hasNoSpouseDependents;
    }
    
    
    /**
     * @return Returns the ssnVerification.
     */
    public SSNVerification getSsnVerification()
    {
        return ssnVerification;
    }
    /**
     * @param ssnVerification The ssnVerification to set.
     */
    public void setSsnVerification(SSNVerification ssnVerification)
    {
        this.ssnVerification = ssnVerification;
    }
    
    /**
     * @return Returns the vpidEntityKeys.
     */
    public Set getVpidKeys()
    {
        return vpidKeys;
    }
    /**
     * @param vpidEntityKeys The vpidEntityKeys to set.
     */
    public void setVpidKeys(Set vpidEntityKeys)
    {
        this.vpidKeys = vpidEntityKeys;
    }
    
    /**
     * @return Returns the veteranDataProcessed.
     */
    public boolean isVeteranDataProcessed()
    {
        return veteranDataProcessed;
    }
    /**
     * @param veteranDataProcessed The veteranDataProcessed to set.
     */
    public void setVeteranDataProcessed(boolean veteranDataProcessed)
    {
        this.veteranDataProcessed = veteranDataProcessed;
    }
	public boolean isVeteranDataAcquired() {
		return veteranDataAcquired;
	}
	public void setVeteranDataAcquired(boolean veteranDataAcquired) {
		this.veteranDataAcquired = veteranDataAcquired;
	}
	public List getVetFileOutputData() {
		return vetFileOutputData;
	}
	public void setVetFileOutputData(List vetFileOutputData) {
		this.vetFileOutputData = vetFileOutputData;
	}
    
	public boolean isReachMaxSize() {
		return reachMaxSize;
	}

	public void setReachMaxSize(boolean reachMaxSize) {
		this.reachMaxSize = reachMaxSize;
	}
}
