package gov.va.med.esr.common.batchprocess;

import java.text.SimpleDateFormat;
import java.util.Calendar;

import gov.va.med.fw.io.FileNameAppender;

/**
 * Appends a dynamic file name extension to the SSN verification file sent to
 * SSA.
 * 
 * @author Rajiv Patnaik Created on Mar 24, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class SSNVerificationFileNameAppender implements FileNameAppender
{
    private String fileExtension;

    /**
     * Input file from HEC is a txt format with the name "SSA" . "rdate". The
     * "rdate" file extension uses the format YY(2 characters) Gregorian Date (3
     * characters)Numeric(1 character) and is used as a ConnectDirect file
     * submission variable. The final numeric is like a time submission (AM-1 vs
     * PM-2). So a file submitted this morning (before 10:30AM), March 17, 2006
     * would be SSA.r060761 and a PM submission would be SSA.r060762
     */
    public String getFileNameSuffix(Object obj)
    {
        String date = new SimpleDateFormat("yyDDD").format(Calendar
                .getInstance().getTime());

        //Calendar returns AM = 0 and PM =1. So increment by 1
        int timeSubmission = Calendar.getInstance().get(Calendar.AM_PM) + 1;

        return (date + timeSubmission + fileExtension);
    }

     /**
     * @return Returns the fileExtension.
     */
    public String getFileExtension()
    {
        return fileExtension;
    }

    /**
     * @param fileExtension
     *            The fileExtension to set.
     */
    public void setFileExtension(String fileExtension)
    {
        this.fileExtension = fileExtension;
    }
}