package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.lookup.SSAMessage;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.person.SSNVerificationDetail;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * This contains data to write to a output file during the Request SSN verification Process
 * and contain data from the SSN Verification Process Presponse files.
 *   
 * @author Rajiv Patnaik
 * Created on Mar 6, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class SSASSNVerificationData extends BatchProcessPersonIdentityTraits
{
    private static final long serialVersionUID = 6151448811095719638L;
    
    private String entryCode;
    private String processingCode;    
    private String incomeYear;
    private String HECInternalID;
    private String spouseCode;
    private String verificationCode;
    private String requestCode;
    private String ssnId; 
    private String vpidValue; 
    private String personId;
    
    private String filler = " ";
    
    /**
     * These are properties that will be used by rules during the Verification Response process
     */
    private boolean HECInternalIdMatched;
    private SSNVerificationDetail ssnVerificationDetail;    
    private SSAVerificationStatus ssaVerificationStatus;    
    private SSAMessage ssaMessage;
    private boolean ssnVerificationForSpouseOrDependent; 
    private boolean ssnVerificationForSpouse;
    private boolean ssnVerificationForDependent;

    private static final String  ENTRY_CODE = "TPV";
    private static final String  PROCESSING_CODE = "212";
    private static final String  INCOME_YEAR = null;
    private static final String  REQUEST_CODE = "AVAH";
    
    /**
     * @return Returns the entryCode.
     */
    public String getEntryCode()
    {
        return ENTRY_CODE;
    }
    /**
     * @param entryCode The entryCode to set.
     */
    public void setEntryCode(String entryCode)
    {
        this.entryCode = entryCode;
    }
    /**
     * @return Returns the hECInternalID.
     */
    public String getHECInternalID()
    {
        return HECInternalID;
    }
    /**
     * @param internalID The hECInternalID to set.
     */
    public void setHECInternalID(String internalID)
    {
        HECInternalID = internalID;
    }
    /**
     * @return Returns the incomeYear.
     */
    public String getIncomeYear()
    {
        return INCOME_YEAR;
    }
    /**
     * @param incomeYear The incomeYear to set.
     */
    public void setIncomeYear(String incomeYear)
    {
        this.incomeYear = incomeYear;
    }
    /**
     * @return Returns the processingCode.
     */
    public String getProcessingCode()
    {
        return PROCESSING_CODE;
    }
    /**
     * @param processingCode The processingCode to set.
     */
    public void setProcessingCode(String processingCode)
    {
        this.processingCode = processingCode;
    }
    /**
     * @return Returns the requestCode.
     */
    public String getRequestCode()
    {
        return REQUEST_CODE;
    }
    /**
     * @param requestCode The requestCode to set.
     */
    public void setRequestCode(String requestCode)
    {
        this.requestCode = requestCode;
    }
    /**
     * @return Returns the spouseCode.
     */
    public String getSpouseCode()
    {
        return spouseCode;
    }
    /**
     * @param spouseCode The spouseCode to set.
     */
    public void setSpouseCode(String spouseCode)
    {
        this.spouseCode = spouseCode;
    }
    
    /**
     * @return Returns the ssnId.
     */
    public String getSsnId()
    {
        return ssnId;
    }
    /**
     * @param ssnId The ssnId to set.
     */
    public void setSsnId(String ssnId)
    {
        this.ssnId = ssnId;
    }
    
    /**
     * @return Returns the ssnVerificationForSpouseOrDependent.
     */
    public boolean isSsnVerificationForSpouseOrDependent()
    {
        return ssnVerificationForSpouseOrDependent;
    }
    /**
     * @param ssnVerificationForSpouseOrDependent The ssnVerificationForSpouseOrDependent to set.
     */
    public void setSsnVerificationForSpouseOrDependent(
            boolean ssnVerificationForSpouseOrDependent)
    {
        this.ssnVerificationForSpouseOrDependent = ssnVerificationForSpouseOrDependent;
    }
    
    /**
     * @return Returns the ssnVerificationForDependent.
     */
    public boolean isSsnVerificationForDependent()
    {
        return ssnVerificationForDependent;
    }
    /**
     * @param ssnVerificationForDependent The ssnVerificationForDependent to set.
     */
    public void setSsnVerificationForDependent(
            boolean ssnVerificationForDependent)
    {
        this.ssnVerificationForDependent = ssnVerificationForDependent;
    }
    /**
     * @return Returns the ssnVerificationForSpouse.
     */
    public boolean isSsnVerificationForSpouse()
    {
        return ssnVerificationForSpouse;
    }
    /**
     * @param ssnVerificationForSpouse The ssnVerificationForSpouse to set.
     */
    public void setSsnVerificationForSpouse(boolean ssnVerificationForSpouse)
    {
        this.ssnVerificationForSpouse = ssnVerificationForSpouse;
    }
    /**
     * @return Returns the verificationCode.
     */
    public String getVerificationCode()
    {
        return verificationCode;
    }
    /**
     * @param verificationCode The verificationCode to set.
     */
    public void setVerificationCode(String verificationCode)
    {
        this.verificationCode = verificationCode;
    }
    
    /**
     * @return Returns the ssaMessage.
     */
    public SSAMessage getSsaMessage()
    {
        return ssaMessage;
    }
    /**
     * @param ssaMessage The ssaMessage to set.
     */
    public void setSsaMessage(SSAMessage ssaMessage)
    {
        this.ssaMessage = ssaMessage;
    }
    /**
     * @return Returns the ssaVerificationStatus.
     */
    public SSAVerificationStatus getSsaVerificationStatus()
    {
        return ssaVerificationStatus;
    }
    /**
     * @param ssaVerificationStatus The ssaVerificationStatus to set.
     */
    public void setSsaVerificationStatus(
            SSAVerificationStatus ssaVerificationStatus)
    {
        this.ssaVerificationStatus = ssaVerificationStatus;
    }
    /**
     * @return Returns the ssnVerificationDetail.
     */
    public SSNVerificationDetail getSsnVerificationDetail()
    {
        return ssnVerificationDetail;
    }
    
    /**
     * @return Returns the filler.
     */
    public String getFiller()
    {
        return filler;
    }
    /**
     * @param filler The filler to set.
     */
    public void setFiller(String filler)
    {
        this.filler = filler;
    }
    
    /**
     * @return Returns the hECInternalIdMatched.
     */
    public boolean isHECInternalIdMatched()
    {
        return HECInternalIdMatched;
    }
    /**
     * @param internalIdMatched The hECInternalIdMatched to set.
     */
    public void setHECInternalIdMatched(boolean internalIdMatched)
    {
        HECInternalIdMatched = internalIdMatched;
    }
    
    
    /**
     * @return Returns the vpidValue.
     */
    public String getVpidValue()
    {
        return vpidValue;
    }
    
    /**
     * @param vpidValue The vpidValue to set.
     */
    public void setVpidValue(String vpidValue)
    {
        this.vpidValue = vpidValue;
    }
        
    public String getPersonId() {
		return personId;
	}
	public void setPersonId(String personId) {
		this.personId = personId;
	}
	
	/**
     * @param ssnVerificationDetail The ssnVerificationDetail to set.
     */
    public void setSsnVerificationDetail(
            SSNVerificationDetail ssnVerificationDetail)
    {
        this.ssnVerificationDetail = ssnVerificationDetail;
    }
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);

        builder.append("entryCode", this.entryCode);
        builder.append("processingCode", this.processingCode);
        builder.append("incomeYear", this.incomeYear);
        builder.append("HECInternalID", this.HECInternalID);
        builder.append("spouseCode", this.spouseCode);
        builder.append("verificationCode", this.verificationCode);
        builder.append("requestCode", this.requestCode);
        builder.append("ssnId", this.ssnId);
        builder.append("vpidValue", this.vpidValue);
        builder.append("personId", this.personId);
        
    }     
}
