package gov.va.med.esr.common.batchprocess;


import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.SHADDocument;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.esr.common.model.registry.RegistryTraitDetail;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import gov.va.med.fw.util.StringUtils;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

/**
 * Parses a SHAD Registry input data record and creates a SHAD Registry object from it.
 * 
 * @author Rajiv Patnaik
 * Created on Apr 14, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class SHADRegistryFileData extends LoadRegistryFileData
{	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private static Class[] AUTO_REGISTER_CLASSES = new Class[] {SHAD.class, SHADDocument.class};
	
	static {
		RawFileDataContainerUtils.autoRegisterConvertersForClasses(AUTO_REGISTER_CLASSES);
	}
	
    /* (non-Javadoc)
     * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);
        
    } 	
    
    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow, gov.va.med.fw.io.ClassMapping)
     */
    public void setRawFileData(String rawFileData, DataRow parsedRow,
            ClassMapping classMapping) throws Exception
    {
        SHAD shadRegistry = new SHAD();
        SHADDocument document = new SHADDocument();
        RegistryTrait trait = new RegistryTrait();
        RegistryTraitDetail traitDetail = new RegistryTraitDetail();
        
        int i=0; 
        shadRegistry.setClaimNumber(StringUtils.stripToNull(parsedRow.getString(i++))); 
		// CodeCR 7265: SSN values don't include leading 0s, left pad to put them back in
        trait.setSsn(buildSsnValue(parsedRow.getString(i++)));
        trait.setLastName(StringUtils.stripToNull(parsedRow.getString(i++)));
		trait.setFirstName(StringUtils.stripToNull(parsedRow.getString(i++)));
		trait.setMiddleName(StringUtils.stripToNull(parsedRow.getString(i++)));
		trait.setPrefix(StringUtils.stripToNull(parsedRow.getString(i++)));
		trait.setEducationalDegree(StringUtils.stripToNull(parsedRow.getString(i++)));
		trait.setSuffix(StringUtils.stripToNull(parsedRow.getString(i++)));
		RawFileDataContainerUtils.setConvertedField(shadRegistry,"shadIndicator", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(document,"documentType", parsedRow.getString(i++));
		traitDetail.setMilitaryServiceNumber(StringUtils.stripToNull(parsedRow.getString(i++)));
		RawFileDataContainerUtils.setConvertedField(document,"receivedDate", parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField(trait, REGISTRY_TYPE,
                RegistryType.CODE_SHAD_REGISTRY.getCode());
		
		trait.addRegistryTraitDetail(traitDetail);
		shadRegistry.setRegistryTrait(trait);
		shadRegistry.addDocument(document);
		
		setRegistry(shadRegistry);

    }

    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
     */
    public OrderedMap getRawFileData() throws Exception
    {
        // no op as this class is used only for parsing data from a input file
        return null;
    }

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#getClassesForAutoRegisterConverters()
	 */
	public Class[] getClassesForAutoRegisterConverters() {
		return AUTO_REGISTER_CLASSES;
	}
}
