/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.service.ServiceException;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
/**
 * Resend QRY-Z11 messages to send to VBA for people with a previously VBA Query, 
 * where VBA had a DLL error message.  Do not resend if the Eligibility Verification Status 
 * is Verified -- just clean up the data.
 * 
 * Created Oct 29, 2008 4:13:36 PM
 * @author DNS   CHENJ2
 */
public class ResendQRYZ11ForVBAErrorProcess extends GenerateQRYZ11Process {
	
	private static final String UPDATE_ELIG_STATUS = "resendQRYZ11ForVBAError.updateEligibilityVerStatus"; 
	private static final String CLOSE_WORKCASE = "resendQRYZ11ForVBAError.closeWorkcase"; 
	private static final String PARAM_PERSONID = "personId";
	private static final String PARAM_CASEID = "caseId";

	/**
     * Processes data for a particular person
     * @param key
     * @param VPID
     * @throws ServiceException 
     */
    protected void processRecord(PersonEntityKey key, Object[] dataRow) throws Exception
    {
        String VPID = (String) dataRow[1];
    	String eligStatusCode = (String) dataRow[2];
       	BigDecimal workCaseId = (BigDecimal) dataRow[3];

    	// If the person is already verified, then no need to resend QRYZ11,
		// just cleanup the data
     	if (EligibilityStatus.CODE_VERIFIED.getCode().equals(eligStatusCode))
        {	
     		Map contextData = new HashMap();
    		contextData.put("personId", new BigDecimal(key.getKeyValueAsString()));		
     		AbstractDAOAction callback = new AbstractDAOAction(contextData) { 
				public Object execute(Session session) {
					Query query = session.getNamedQuery(UPDATE_ELIG_STATUS);
					query.setParameter(PARAM_PERSONID, (BigDecimal)getContextData().get("personId"));
	                return new Integer(query.executeUpdate());                				
	            }
			};
	     	Integer updateCount = (Integer) getDao().execute(callback);
	     	if (updateCount.intValue() < 1) {
                if(logger.isWarnEnabled())
                    logger.warn(getProcessName() + ": EligibilityVerification not updated for personId=" + key.getKeyValueAsString());

	     	}
    	}
    	else {
    		// Otherwise, send QRY Z11
    		getMessagingService().generateMessage(key, VPID);
    	}
    	
    	// finally, close the workflow case
    	Map contextData = new HashMap();
		contextData.put("caseId", workCaseId);		
 		AbstractDAOAction callback = new AbstractDAOAction(contextData) { 
			public Object execute(Session session) {
				Query query = session.getNamedQuery(CLOSE_WORKCASE);
				query.setParameter(PARAM_CASEID, (BigDecimal)getContextData().get("caseId"));
                return new Integer(query.executeUpdate());  
             }
		};
		Integer updateCount = (Integer) getDao().execute(callback);
     	if (updateCount.intValue() < 1) {
            if(logger.isWarnEnabled())
                logger.warn(getProcessName() + ": Workflow case status not updated to Closed for caseId=" + workCaseId);
     	}
   }
}
