/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.batchprocess.DataQueryProcessStatistics;

/**
 * Initial javadoc for class RequestSSNVerificationStatistics.
 * TODO - Add content here
 * 
 * Created Oct 26, 2006 3:33:47 PM
 * @author DNS   BOHMEG
 */
public class RequestSSNVerificationStatistics extends
		DataQueryProcessStatistics {
	/**
	 * 
	 */
	private static final long serialVersionUID = -8306061169386804755L;
	
	private int numberOfRecordsIgnoredForPendingUpdateToIdentityTraits;

    private Date vetProcessingStartDate;
    private Date vetProcessingEndDate;

    private int numberOfTotalVetRecords;
    private int numberOfSuccessfulVetRecords;
    private int numberOfErrorVetRecords;
    
    private int numberOfSuccessfulSDRecords;
    private int numberOfErrorSDRecords;
    private int numberOfVetRecordsIgnoredForPendingUpdateToIdentityTraits;
    
    
    
	/**
	 * @return Returns the numberOfRecordsIgnoredForPendingUpdateToIdentityTraits.
	 */
	public int getNumberOfRecordsIgnoredForPendingUpdateToIdentityTraits() {
		return numberOfRecordsIgnoredForPendingUpdateToIdentityTraits;
	}

	/**
	 * @return Returns the numberOfRecordsIgnoredForPendingUpdateToIdentityTraits.
	 */
	public synchronized void incrementNumberOfRecordsIgnoredForPendingUpdateToIdentityTraits() {
		incrementNumberOfRecordsIgnoredForPendingUpdateToIdentityTraits(false);
	}

	/**
	 * @return Returns the numberOfRecordsIgnoredForPendingUpdateToIdentityTraits.
	 */
	public synchronized void incrementNumberOfRecordsIgnoredForPendingUpdateToIdentityTraits(boolean effectTotal) {
		numberOfRecordsIgnoredForPendingUpdateToIdentityTraits++;
		if(effectTotal)
			super.incrementNumberOfTotalRecords();
	}
	
	/**
	 * @param numberOfRecordsIgnoredForPendingUpdateToIdentityTraits The numberOfRecordsIgnoredForPendingUpdateToIdentityTraits to set.
	 */
	public synchronized void setNumberOfRecordsIgnoredForPendingUpdateToIdentityTraits(
			int numberOfRecordsIgnoredForPendingUpdateToIdentityTraits) {
		this.numberOfRecordsIgnoredForPendingUpdateToIdentityTraits = numberOfRecordsIgnoredForPendingUpdateToIdentityTraits;
	}
	
    /**
     * 
     * @return numberOfErrorSDRecords Number of errored spouse and dependent records
     */
	public int getNumberOfErrorSDRecords() {
        return numberOfErrorSDRecords;
    }

    /**
     * 
     * @param numberOfErrorSDRecords Number of errored spouse and dependent records
     */
    public synchronized void setNumberOfErrorSDRecords(int numberOfErrorSDRecords) {
        this.numberOfErrorSDRecords = numberOfErrorSDRecords;
    }

    /**
     * 
     * @return numberOfErrorVetRecords Number of errored veteran records
     */
    public int getNumberOfErrorVetRecords() {
        return numberOfErrorVetRecords;
    }

    /**
     * 
     * @param numberOfErrorVetRecords Number of errored veteran records
     */
    public synchronized void setNumberOfErrorVetRecords(int numberOfErrorVetRecords) {
        this.numberOfErrorVetRecords = numberOfErrorVetRecords;
    }

    /**
     * 
     * @return numberOfSuccessfulSDRecords number of Spouse and dependents records successful
     */
    public int getNumberOfSuccessfulSDRecords() {
        return numberOfSuccessfulSDRecords;
    }

    /**
     * 
     * @param numberOfSuccessfulSDRecords number of Spouse and dependents records successful
     */
    public synchronized void setNumberOfSuccessfulSDRecords(int numberOfSuccessfulSDRecords) {
        this.numberOfSuccessfulSDRecords = numberOfSuccessfulSDRecords;
    }

    /**
     * 
     * @return numberOfSuccessfulVetRecords number of veteran records processed successful
     */
    public int getNumberOfSuccessfulVetRecords() {
        return numberOfSuccessfulVetRecords;
    }

    /**
     * 
     * @param numberOfSuccessfulVetRecords number of veteran records processed successful
     */
    public synchronized void setNumberOfSuccessfulVetRecords(int numberOfSuccessfulVetRecords) {
        this.numberOfSuccessfulVetRecords = numberOfSuccessfulVetRecords;
    }

    /**
     * 
     * @return numberOfTotalVetRecords total number of veteran recors to be processed
     */
    public int getNumberOfTotalVetRecords() {
        return numberOfTotalVetRecords;
    }

    public synchronized void setNumberOfTotalVetRecords(int numberOfTotalVetRecords) {
        this.numberOfTotalVetRecords = numberOfTotalVetRecords;
    }

    /**
     * 
     * @return Total number of veteran records ignored to process
     */
    public int getNumberOfVetRecordsIgnoredForPendingUpdateToIdentityTraits() {
        return numberOfVetRecordsIgnoredForPendingUpdateToIdentityTraits;
    }

    public synchronized void setNumberOfVetRecordsIgnoredForPendingUpdateToIdentityTraits(
            int numberOfVetRecordsIgnoredForPendingUpdateToIdentityTraits) {
        this.numberOfVetRecordsIgnoredForPendingUpdateToIdentityTraits = numberOfVetRecordsIgnoredForPendingUpdateToIdentityTraits;
    }

    /**
     * 
     * @return vetProcessingEndDate Veteran data processing end date
     */
    public Date getVetProcessingEndDate() {
        return vetProcessingEndDate;
    }

    public void setVetProcessingEndDate(Date vetProcessingEndDate) {
        this.vetProcessingEndDate = vetProcessingEndDate;
    }

    /**
     * 
     * @return vetProcessingStartDate Veteran Data Processing StartDate
     */
    public Date getVetProcessingStartDate() {
        return vetProcessingStartDate;
    }

    public void setVetProcessingStartDate(Date vetProcessingStartDate) {
        this.vetProcessingStartDate = vetProcessingStartDate;
    }

    protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("numberOfRecordsIgnoredForPendingUpdateToIdentityTraits", numberOfRecordsIgnoredForPendingUpdateToIdentityTraits);
        
        builder.append("Total Number of Veteran records to be processed",numberOfTotalVetRecords);
        builder.append("Number of Successful Veteran records",numberOfSuccessfulVetRecords);
        builder.append("Number of Error Veteran records",numberOfErrorVetRecords);
        builder.append("Number of Veteran records Ignored for PendingUpdateToIdentityTraits",numberOfVetRecordsIgnoredForPendingUpdateToIdentityTraits);
        builder.append("Veteran Records processing StartDate",vetProcessingStartDate);
        builder.append("Veteran Records processing EndDate",vetProcessingEndDate);


        builder.append("Number of Successful Spouse and Dependents records",numberOfSuccessfulSDRecords);
        builder.append("Number of Error Spouse and Dependents records",numberOfErrorSDRecords);
	}
}
