package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.batchprocess.AbstractDataFileIncrementalProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.hibernate.Query;
import org.hibernate.Session;



public class ReprocessContinuousEnrollmentRecord extends AbstractDataFileIncrementalProcess {
    
    private EligibilityEnrollmentService eligibilityEnrollmentService = null;
    

    public void processDataRecords(
            DataFileProcessExecutionContext context, List beans) {
        
        if (logger.isDebugEnabled())
        {
            int listSize = 0;
            if ( beans != null ) listSize = beans.size();
            
            logger.error("Processing VPID  " + listSize);
        }
        
        for ( int i=0; beans != null && i< beans.size(); i++)
        {
            VPIDFileData dataRecord = (VPIDFileData) beans.get(i);
            String personIdinString = dataRecord.getVpid();
            System.out.println(personIdinString);

            try {
                
                BigDecimal personId = new BigDecimal(personIdinString);
                                
                if (logger.isDebugEnabled())
                       logger.error("Processing person ID  " + dataRecord.getVpid());
                
                /*Add logic into the service to override and then start calculate EE*/                                
                this.getEligibilityEnrollmentService().processCalculateEEOverride(new PersonIdEntityKeyImpl(personId), true, true);
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();                
                
                
            } catch (Exception e) {
                if (logger.isErrorEnabled())
                   logger.error("Error Reprocessing Continuos Enrollment Record for person ID " + dataRecord.getVpid(), e);
                    
                context.getProcessStatistics().incrementNumberOfErrorRecords();
            }
            finally
            {
                // Check if we need to update the job result
                if(shouldUpdateJobResult(context))
                        updateJobResult(context);
                
                if ( isInterrupted(context))
                {
                    break;
                }
            }
            
        }
    }


    
    
    /**
     * @return Returns the eligibilityEnrollmentService.
     */
    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        return eligibilityEnrollmentService;
    }

    /**
     * @param eligibilityEnrollmentService The eligibilityEnrollmentService to set.
     */
    public void setEligibilityEnrollmentService(
            EligibilityEnrollmentService eligibilityEnrollmentService) {
        this.eligibilityEnrollmentService = eligibilityEnrollmentService;
    }
    
    
}
