/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.batchprocess;

import org.apache.commons.lang.StringUtils;

import gov.va.med.fw.io.FileNameAppender;
import gov.va.med.fw.service.AbstractComponent;

/**
 * Determines the file name for the exception file (since configured fileLocation
 * will only be a path).  This returned file name is "appended" to the path.
 * 
 * Created May 9, 2006 12:54:34 PM
 * 
 * @author DNS   BOHMEG
 */
public class ReceiveSignatureInformationFileExceptionFileNameAppender extends
		AbstractComponent implements FileNameAppender {
	private String inputExtension;

	private String outputExtension;

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.io.FileNameAppender#getFileNameSuffix(java.lang.Object)
	 */
	public String getFileNameSuffix(Object obj) {
		String currentInputFileName = (String) obj;
		// since there is no guarantee on case here, let's support both
		String resultFromReplacement = StringUtils.replace(currentInputFileName, inputExtension, outputExtension);
		if(currentInputFileName.equals(resultFromReplacement)) {
			resultFromReplacement = StringUtils.replace(currentInputFileName, inputExtension.toUpperCase(), outputExtension);
			if(currentInputFileName.equals(resultFromReplacement))
				resultFromReplacement = StringUtils.replace(currentInputFileName, inputExtension.toLowerCase(), outputExtension);
		}
		return resultFromReplacement;
	}

	/**
	 * @return Returns the inputExtension.
	 */
	public String getInputExtension() {
		return inputExtension;
	}

	/**
	 * @param inputExtension
	 *            The inputExtension to set.
	 */
	public void setInputExtension(String inputExtension) {
		this.inputExtension = inputExtension;
	}

	/**
	 * @return Returns the outputExtension.
	 */
	public String getOutputExtension() {
		return outputExtension;
	}

	/**
	 * @param outputExtension
	 *            The outputExtension to set.
	 */
	public void setOutputExtension(String outputExtension) {
		this.outputExtension = outputExtension;
	}

}
