package gov.va.med.esr.common.batchprocess;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.esr.common.model.registry.RegistryTraitDetail;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import gov.va.med.fw.util.StringUtils;

/**
 * Parses a Purple Heart input data record and creates a Purple Heart Registry object from it.
 * 
 * @author Rajiv Patnaik
 * Created on Apr 14, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class PurpleHeartRegistryFileData extends LoadRegistryFileData
{	
    private static final long serialVersionUID = -1099115892788205428L;

    private static Class[] AUTO_REGISTER_CLASSES = new Class[] {PurpleHeart.class, PurpleHeartDocument.class};
	
	static {
		RawFileDataContainerUtils.autoRegisterConvertersForClasses(AUTO_REGISTER_CLASSES);
	}
	
	
    /* (non-Javadoc)
     * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);
        
    }    

    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow, gov.va.med.fw.io.ClassMapping)
     */
    public void setRawFileData(String rawFileData, DataRow parsedRow,
            ClassMapping classMapping) throws Exception
    {
        PurpleHeart purpleHeart = new PurpleHeart();
        PurpleHeartDocument document = new PurpleHeartDocument();
        RegistryTrait trait = new RegistryTrait();
        RegistryTraitDetail traitDetail = new RegistryTraitDetail();
        
        int i=0; 
        
        // CodeCR 7265: SSN values don't include leading 0s, left pad to put them back in
        trait.setSsn(buildSsnValue(parsedRow.getString(i++)));
        trait.setLastName(StringUtils.stripToNull(parsedRow.getString(i++)));
		trait.setFirstName(StringUtils.stripToNull(parsedRow.getString(i++)));
		trait.setMiddleName(StringUtils.stripToNull(parsedRow.getString(i++)));
		trait.setPrefix(StringUtils.stripToNull(parsedRow.getString(i++)));
		trait.setEducationalDegree(StringUtils.stripToNull(parsedRow.getString(i++)));
		trait.setSuffix(StringUtils.stripToNull(parsedRow.getString(i++)));

		purpleHeart.setPhIndicator(buildBooleanValue(parsedRow.getString(i++)));
		RawFileDataContainerUtils.setConvertedField(purpleHeart,"status", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(purpleHeart,"statusLastEditDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(purpleHeart,"rejectionRemark", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(purpleHeart,"facility", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(document,"documentType", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(document,"dataSource", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(document,"receivedDate", parsedRow.getString(i++));
		RawFileDataContainerUtils.setConvertedField(document,"loginDate", parsedRow.getString(i++));
		document.setAcceptable(buildBooleanValue(parsedRow.getString(i++)));
		RawFileDataContainerUtils.setConvertedField(document,"unacceptableRemarks", parsedRow.getString(i++));
		traitDetail.setMilitaryServiceNumber(StringUtils.stripToNull(parsedRow.getString(i++)));
        RawFileDataContainerUtils.setConvertedField(trait, REGISTRY_TYPE,
                RegistryType.CODE_PH_REGISTRY.getCode());
		
		trait.addRegistryTraitDetail(traitDetail);
		purpleHeart.setRegistryTrait(trait);
		purpleHeart.addDocument(document); 
		
		setRegistry(purpleHeart);

    }

    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
     */
    public OrderedMap getRawFileData() throws Exception
    {
        //no op as this class is used only for parsing data from a input file
        return null;
    }

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#getClassesForAutoRegisterConverters()
	 */
	public Class[] getClassesForAutoRegisterConverters() {
		return AUTO_REGISTER_CLASSES;
	}

}
